#include "StdAfx.h"
#include "IPv4ListenerBase.h"
#include "ServerException.h"
#include "TextTools.h"


CIPv4ListenerBase::CIPv4ListenerBase(void)
{
}

CIPv4ListenerBase::~CIPv4ListenerBase(void)
{
	StopListenerBase();
}



/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CIPv4ListenerBase::InitListenerBase(CIServerToolWrap serverTool, int errorRetryTime)
{
	m_serverTool = serverTool;
	m_errorRetryTime = errorRetryTime;
	m_disableNewConnectionEndTime = 0;
}

/*!
	Jn
*/
void CIPv4ListenerBase::StartListenerBase()
{
	if(OpenPorts())
		throw CServerStartErrorException(GetListenerClassName(), _U16("ڑ̑҂󂯊JnɎs܂"));

	if(StartThread())
		throw CServerStartErrorException(GetListenerClassName(), _U16("Xbh̋NɎs܂"));
}

/*!
	~
*/
void CIPv4ListenerBase::StopListenerBase()
{
	//	Xbh~
	EndThread();

	//	|
	CloseAllPorts();
}

/*!
	N[Abv
*/
void CIPv4ListenerBase::CloseAllPorts()
{
	//	|
	for(int i=0;i<m_listeners.GetCount();i++)
		delete m_listeners[i];
	m_listeners.RemoveAll();
}

/*!
	ݒ肩|[gǉ
*/
void CIPv4ListenerBase::AddPortsFromSetting(CUTF8String strPorts)
{
	//	|[g擾
	CUTF8StringArray	ports;
	CTextTools::GetAllToken(strPorts, ports, _U8(","), TRUE);

	//	o^
	for(int i=0;i<ports.GetCount();i++)
	{
		//	|[gԍ擾
		int port = CTextTools::StrTol(ports[i]);
		if(port > 0 && port < 65536)
			AddPort(port);
	}
}

/*!
	|[g̒ǉ
*/
void CIPv4ListenerBase::AddPort(int port)
{
	//	֎~
	if(IsRunning())
		return;

	//	ǉ
	m_listeners.Add(new CListenSocket(port));

	//	O
	m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_INFO, CUTF8String::GetFormat(_U16("|[g %d ǉ܂"), port));

}


/*!
	ꎞIɎ󂯕t~
*/
void CIPv4ListenerBase::ForceDisableNewConnection(int time)
{
	m_disableNewConnectionEndTime = GetTickCount() + time;
}

/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CIPv4ListenerBase::ThreadMain()
{
	//	G[[v
	while(!GetBreak())
	{
		//	[v
		AcceptLoop();

		//	|[g̑҂󂯂蒼
		while(!GetBreak() && OpenPorts())
			WaitForSomeObjects(m_errorRetryTime, GetBreakEvent());	//	G[Ȃ̂ŁA΂炭ҋ@
	}

	//	
	ClosePorts();

	//	ŏIXe[^X
	m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_INFO, _U16("|[g҂󂯂~܂"));
}

/*!
	t[v
*/
int CIPv4ListenerBase::AcceptLoop()
{
	//	҂󂯃[v
	while(!GetBreak())
	{
		//	݂
		if(AcceptConnections())
			return(-1);		//	G[

		//	Cxg҂
		WaitNextRequest();
	}

	return(0);
}


/*!
	|[gJ
*/
int CIPv4ListenerBase::OpenPorts()
{
	//	܂́Aׂĕ
	ClosePorts();

	//	SẴ|[gJ
	for(int i=0;i<m_listeners.GetCount();i++)
	{
		//	҂󂯊Jn
		if(m_listeners[i]->StartListen())
		{
			//	G[
			m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_ERROR,
				CUTF8String::GetFormat(_U16("|[g %d ̑҂󂯊JnɎs܂"), m_listeners[i]->GetPort()));
			return(-1);
		}
	}

	//	
	m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_INFO, _U16("S|[g̑҂󂯂Jn܂"));
	return(0);
}

/*!
	|[g
*/
void CIPv4ListenerBase::ClosePorts()
{
	//	SẴ|[g
	for(int i=0;i<m_listeners.GetCount();i++)
	{
		//	҂󂯒~
		m_listeners[i]->EndListen();
	}
}


/*!
	ڑ󂯕t
*/
int CIPv4ListenerBase::AcceptConnections()
{
	//	e|
	SOCKET		newSock;
	CIPAddress	ip;

	while(1)
	{
		//	SẴ|[g`FbN
		int	acceptedCount = 0;
		for(int i=0;i<m_listeners.GetCount();i++)
		{
			//	t݂
			switch(m_listeners[i]->TryAccept(newSock, ip))
			{
			//	\PbgȂ
			case LISTEN_SOCKET_NOCLIENT:
				break;

			//	G[
			case LISTEN_SOCKET_ERROR:
				m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_ERROR,
					CUTF8String::GetFormat(_U16("|[g %s ̐ڑtŃG[܂"), m_listeners[i]->GetPort()));
				return(-1);

			//	VKڑ
			case LISTEN_SOCKET_ACCEPTED:
				acceptedCount++;

				//	H
				if(InDisableMode())
					closesocket(newSock);		//	폜
				else
					OnNewConnection(newSock);

				TRACE_U8(_U16("New connection\n"));
				break;
			}
		}

		//	ʖ
		if(acceptedCount == 0)
			return(0);
	}
}



/*!
	ڑ̂҂
*/
void CIPv4ListenerBase::WaitNextRequest()
{
	//	Cxg
	int	eventCount = m_listeners.GetCount();
	if(eventCount > MAXIMUM_WAIT_OBJECTS - 1)
		eventCount = MAXIMUM_WAIT_OBJECTS - 1;

	//	ׂẴCxg擾
	HANDLE	waits[MAXIMUM_WAIT_OBJECTS];
	for(int i=0;i<eventCount;i++)
		waits[i+1] = m_listeners[i]->GetEventHandle();

	//	҂
	waits[0] = GetBreakEvent();
	::WaitForMultipleObjects(eventCount + 1, waits, FALSE, INFINITE);
}


/*!
	~H
*/
int CIPv4ListenerBase::InDisableMode()
{
	if(m_disableNewConnectionEndTime != 0)
	{
		DWORD	tick = GetTickCount();
		if(m_disableNewConnectionEndTime < tick || m_disableNewConnectionEndTime >= tick)
		{
			m_disableNewConnectionEndTime = 0;
			return(0);
		}
		return(1);
	}
	return(0);
}
