#include "StdAfx.h"
#include "TextFormatter.h"

CTextFormatter::CTextFormatter(void)
{
}

CTextFormatter::~CTextFormatter(void)
{
}


/*!
	uǉ
*/
void CTextFormatter::AddKey(CString key, CString swapTo)
{
	//	u
	for(int i=0;i<m_escape.GetSize();i++)
		swapTo.Replace(m_escape[i].m_key, m_escape[i].m_data);

	//	ǉ
	m_keys.Add(key, swapTo);
}

/*!
	uǉ
*/
void CTextFormatter::AddKeyFromWorkspace(CWorkspaceAccess workspace, CString keyHeader)
{
	//	ׂĎ擾
	CStringArray	key, data;
	workspace.GetAllKey(key);
	workspace.GetAllData(data);

	//	ǉ
	for(int i=0;i<key.GetSize();i++)
	{
		//	u
		for(int j=0;j<m_escape.GetSize();j++)
			data[i].Replace(m_escape[j].m_key, m_escape[j].m_data);

		m_keys.Add(keyHeader + key[i], data[i]);
	}
}

/*!
	NA
*/
void CTextFormatter::Clear()
{
	m_keys.RemoveAll();
	m_escape.RemoveAll();
}

/*!
	ǉ
*/
void CTextFormatter::AddEscape(CString token, CString escape)
{
	m_escape.Add(token, escape);
}



/*!
	us
*/
CString CTextFormatter::GetFormattedString(CString format, CString keyMarker, CString noMatchKey)
{
	CString	key, left, ret;
	int		index = 0;

	while(GetNextMarker(format, index, keyMarker, left, key))
	{
		ret += left;

		int keyIndex = m_keys.Find(key);
		if(keyIndex == -1)
			ret += noMatchKey;
		else
			ret += m_keys[keyIndex].m_data;
	}

	return(ret + left);
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	}[J؂o
*/
int CTextFormatter::GetNextMarker(CString &format, int &nextIndex, CString &marker, CString &leftText, CString &key)
{
	int	markerLen = marker.GetLength();

	//	ŏ̃}[J擾
	int markStart = format.Find(marker, nextIndex);
	if(markStart == -1)
	{
		leftText = format.Mid(nextIndex);
		return(0);
	}

	//	̃}[J擾
	int markEnd = format.Find(marker, markStart + markerLen);
	if(markEnd == -1)
	{
		leftText = format.Mid(nextIndex);
		return(0);
	}

	//	eLXg؂o
	leftText = format.Mid(nextIndex, markStart - nextIndex);

	//	L[؂o
	key = format.Mid(markStart + markerLen, markEnd - (markStart + markerLen));

	//	̊Jnʒu
	nextIndex = markEnd + markerLen;
	return(1);
}

