#include "StdAfx.h"
#include "PathFilter.h"
#include "IPathManager.h"

#include "Dir.h"

//!	W[
static TCHAR _MODULE_NAME[] = _T("PathFilter");

CPathFilter::CPathFilter(void)
{
}

CPathFilter::~CPathFilter(void)
{
}

/*!
	tB^擾
*/
LPCTSTR CPathFilter::GetFilterName()
{
	return _MODULE_NAME;
};



//////////////////////////////////////////////////////////////////////////////////////////////
//	NGXgM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_
*/
void CPathFilter::FilterRequestHeader(CIConnectionToolWrap filterContext)
{
	//	^[Qbg
	CContextRequestInfo requestInfo = filterContext.GetContxet().GetRequestInfo();
	CContextTargetInfo	targetInfo = filterContext.GetContxet().GetTargetInfo();
	CPathInfo			pathInfo = targetInfo.GetPathInfo();

	//	^[QbgݒH
	if(!targetInfo.TargetIsSet())
	{
		//	pX}l[W擾
		CIPathManagerWrap pathManager = filterContext.GetIServerTool().GetIPathManager();

		//	IuWFNg
		CString	object = requestInfo.GetObject();

		//	pX擾
		if(!pathManager.FindPath(object, requestInfo.GetRequestOption().GetHost(), pathInfo))
			throw CServerResponseException(404, _T("w肳ꂽpX܂"));

		//	^[Qbg̐ݒ
		int	serverPathCount = pathInfo.GetServerPath().GetLength();
		CString	target = pathInfo.GetLocalPath() + object.Mid(serverPathCount);
		target.Replace("/", "\\");

		//	NA
		targetInfo.SetTargetIsExist(FALSE);
		targetInfo.SetTargetIsDirectory(FALSE);
		targetInfo.SetTargetIsHidden(FALSE);

		//	]H
		if(!pathInfo.GetForward().IsEmpty())
		{
			CServerResponseException	move(301, _T("ړĂ"));
			move.AddAdditionalHeader("Location", pathInfo.GetForward());
			throw move;
		}

		//	݊mF
		int exist = CFileDirTools::FileExist(target);

		//	"/"̂ɁAfBNgH
		if(exist == CFileDirTools::FILE_TYPE_DIRECTORY && !CPathTools::CheckBackSlash(target))
			exist = CFileDirTools::FILE_TYPE_NOTFOUND;	//	ȂƂɂ

		//	^[Qbg݊mF
		if(exist != CFileDirTools::FILE_TYPE_NOTFOUND)
		{
			//	݂
			targetInfo.SetTargetIsExist(TRUE);

			//	^[QbgmF
			DWORD attr = CFileDirTools::GetFileAttribute(target);
			if(attr != CFileDirTools::FILE_ATTR_ERROR)
			{
				if(attr & CFileDirTools::FILE_ATTR_DIRECTORY)
				{
					targetInfo.SetTargetIsDirectory(TRUE);
					target = CPathTools::AddBackSlash(target);
				}

				if(attr & CFileDirTools::FILE_ATTR_HIDDEN)
					targetInfo.SetTargetIsHidden(TRUE);
			}
		}

		targetInfo.SetTarget(target);
		TRACE("CPathFilter::TargetSet : %s (Exist : %d)\n", targetInfo.GetTarget(), targetInfo.GetTargetIsExist());
	}
}


