#pragma once
#include "CGICommand.h"
#include "Settings.h"
#include "InterfaceWrapperMacro.h"

class ICGIManager
{
public:
	//!	vCGIR}h邩擾
	virtual int TargetIsCGI(LPCSTR targetPath) = 0;

	//!	vCGIR}h擾
	virtual int GetCGICommand(LPCSTR targetPath, IWorkspaceAccessPtr command) = 0;

	//!	CGIʐݒ擾
	virtual void GetCGIManagerSetting(IWorkspaceAccessRefPtr setting) = 0;
};
//!	|C^^
typedef ICGIManager* ICGIManagerPtr;


/*!
	ICGIManagerbp
*/
class CICGIManagerWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CICGIManagerWrap, ICGIManager, 1);

	//!	vCGIR}h邩擾
	virtual int TargetIsCGI(CString targetPath)
	{
		return m_ifPtr->TargetIsCGI(targetPath);
	}

	//!	vCGIR}h擾
	virtual int GetCGICommand(CString targetPath, CCGICommand command)
	{
		return m_ifPtr->GetCGICommand(targetPath, CWorkspaceAccess(command).GetIWorkspaceAccess());
	}

	//!	CGIʐݒ擾
	virtual CCGIManagerSetting GetCGIManagerSetting()
	{
		CWorkspaceAccess	ret;
		m_ifPtr->GetCGIManagerSetting(ret.GetIWorkspaceAccessRef());
		return ret;
	}
};
