#include "StdAfx.h"
#include "SettingManager.h"
#include "ServerStartErrorException.h"
#include "Dir.h"

#define	CLASS_NAME	"SettingManager"

CSettingManager::CSettingManager(void) :
	m_settingRoot("04WebServer2")
{
	m_serverSetting = m_settingRoot.GetAccess("Setting");
}

CSettingManager::~CSettingManager(void)
{
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CSettingManager::Start(IServerToolPtr serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	ݒ̃[h
	if(m_settingRoot.LoadFromXMLFile(SETTING_FILE))
		throw CServerStartErrorException(CLASS_NAME, "ݒt@C [" + SETTING_FILE + "] ̓ǂݍ݂Ɏs܂B");

	//	u
	OverwriteSetting(m_serverSetting);
}

/*!
	~
*/
void CSettingManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ݒ㏑
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ݒ㏑(ċA)
*/
void CSettingManager::OverwriteSetting(CWorkspaceAccess overwrite)
{
	OverwriteOneSetting(overwrite);

	//	STum[h擾
	CStringArray	nodes;
	overwrite.GetAllSubNode(nodes);

	//	ʂ
	for(int i=0;i<nodes.GetCount();i++)
		OverwriteSetting(overwrite.GetAccess(nodes[i]));


	//	T[o[g
	m_settingSwap.AddSwap("%ServerRoot%", CPathTools::GetAppPath());

	//	T[oo[W
	m_settingSwap.AddSwap("%ServerVersion%", SERVER_VERSION);

	//	T[oo[W
	m_settingSwap.AddSwap("%ServerVersionString%", SERVER_VERSION_STRING);

	//	ݒ(ftHglw肳Ăꍇ̂)
	m_settingRoot.SetAutoSwapDefault(IWorkspaceAutoSwapRet(&m_settingSwap, FALSE));
}

/*!
	ݒ㏑
*/
void CSettingManager::OverwriteOneSetting(CWorkspaceAccess overwrite)
{
	//	SL[擾
	CStringArray	keys;
	overwrite.GetAllKey(keys);

	//	ׂď㏑
	for(int i=0;i<keys.GetCount();i++)
	{
		CString	data = overwrite.GetKeyStr(keys[i], "");

		//	T[o[g
		data.Replace("%ServerRoot%", CPathTools::GetAppPath());

		//	T[oo[W
		data.Replace("%ServerVersion%", SERVER_VERSION);

		//	T[oo[W
		data.Replace("%ServerVersionString%", SERVER_VERSION_STRING);

		overwrite.SetKeyStr(keys[i], data);
	}
}


/*!
	ʏ̎擾
*/
CString CSettingWorkspaceSwap::GetKeyDataSwap(IWorkspace *workspace, const LPCSTR orgKey, CString orgData)
{
	SCOPE_LOCK();

	if(orgData.Find("%") != -1)
	{
		for(int i=0;i<m_keyData.GetCount();i++)
		{
			orgData.Replace(m_keyData[i].m_key, m_keyData[i].m_data);
		}
	}

	return(orgData);
}

/*!
	uǉ
*/
void CSettingWorkspaceSwap::AddSwap(CString key, CString swap)
{
	SCOPE_LOCK();

	m_keyData.Add(key, swap);
}
