#include "StdAfx.h"
#include "FilterManager.h"
#include "ServerInfoFilter.h"
#include "PathFilter.h"
#include "IndexFilter.h"
#include "AccessLogFilter.h"
#include "KeepAliveFilter.h"

CFilterManager::CFilterManager(void)
{
}

CFilterManager::~CFilterManager(void)
{
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	EI
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CFilterManager::Start(IServerToolPtr serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	m_serverTool = serverTool;

	//	T[o
	m_filterFactorys.Add(IFilterFactoryRet(new CServerInfoFilter, TRUE));

	//	pX
	m_filterFactorys.Add(IFilterFactoryRet(new CPathFilter, TRUE));

	//	KeepAlive
	m_filterFactorys.Add(IFilterFactoryRet(new CKeepAliveFilter, TRUE));

	//	CfbNX
	m_filterFactorys.Add(IFilterFactoryRet(new CIndexFilter, TRUE));

	//	ANZXO
	m_filterFactorys.Add(IFilterFactoryRet(new CAccessLogFilter, TRUE));

	//	
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		m_filterFactorys[i]->StartFactory(m_serverTool->GetIServerTool());
}

/*!
	~
*/
void CFilterManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	~
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		m_filterFactorys[i]->StopFactory();

	m_filterFactorys.RemoveAll();
}


/*!
	tB^z擾
*/
void CFilterManager::GetFilterArray(CFilterArray &filters)
{
	SCOPE_LOCK();
	filters.RemoveAll();

	for(int i=0;i<m_filterFactorys.GetSize();i++)
		filters.Add(m_filterFactorys[i]->GetFilter());
}
