#pragma once

#include "IServerTool.h"
#include "SettingManager.h"
#include "NewConnectionQueue.h"
#include "ListenerManager.h"
#include "ConnectionManager.h"
#include "ServerStatusManager.h"

#include "ResponseManager.h"
#include "FilterManager.h"
#include "ManagerInterfaceManager.h"

class CServer : protected IServerTool, protected IServerControl
{
public:
	CServer(void);
	virtual ~CServer(void);

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerControlC^[tF[X擾
	IServerControlIIPtr GetIServerControl() { return IServerControlRet(this, FALSE); };

protected:
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerToolC^[tF[X擾
	IServerToolIIPtr GetIServerTool() { return IServerToolRet(this, FALSE); };

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerControl
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o̊Jn
	virtual void StartServer();

	//!	T[o̒~
	virtual void StopServer();

	//!	݂̐ڑXe[^X擾
	virtual CWorkspaceAccess GetConnectionInfo() { return CWorkspaceAccess(); };


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerTool
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	virtual void WriteSystemLog(CString callerName, int statusCode, CString statusInfo, int autoOffTime = -1) { m_statusManager.WriteSystemLog(callerName, statusCode, statusInfo, autoOffTime); };

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(CString statusName, int status, CString statusInfo = "") { m_statusManager.SetServerStatusInt(statusName, status, statusInfo); };

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(CString statusName, CString status, CString statusInfo = "") { m_statusManager.SetServerStatusStr(statusName, status, statusInfo); };


	//!	ݒ̎擾
	virtual CWorkspaceAccess GetManagerSetting(CString section){ return m_settingManager.GetManagerSetting(section); };

	//!	ݒ̎擾
	virtual CWorkspaceAccess GetFilterSetting(CString section) { return m_settingManager.GetFilterSetting(section); };

	//!	ݒ̎擾
	virtual CWorkspaceAccess GetResponseSetting(CString section) { return m_settingManager.GetResponseSetting(section); };


	//!	݂̃T[oXe[^X擾
	virtual CServerStatus GetServerStatus() { return m_statusManager.GetStatus(); };


	//!	X|X}l[W擾
	virtual IResponseManagerIIPtr GetIResponseManager() { return m_responseManager.GetIResponseManager(); };

	//!	擾
	virtual IFilterManagerIIPtr GetIFilterManager() { return m_filterManager.GetIFilterManager(); };


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃNX
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ݒ}l[W
	CSettingManager				m_settingManager;

	//!	Xe[^X}l[W
	CServerStatusManager		m_statusManager;

	//!	Xi
	CListenerManager			m_listenerManager;

	//!	X|X}l[W
	CResponseManager			m_responseManager;

	//!	tB^}l[W
	CFilterManager				m_filterManager;

	//!	ڑ}l[W
	CConnectionManager			m_connectionManager;

	//!	}l[WC^tF[X}l[W
	CManagerInterfaceManager	m_interfaceManager;


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[os
	CInterlockCounter			m_serverRunning;
};
