#include "StdAfx.h"
#include "NormalListenerConnection.h"
#include "HTTPHeaderParser.h"

#define	MAX_HEADER_SIZE	(16 * 1024)	//	16K
#define	END_HEADER		"\r\n\r\n"

CNormalListenerConnection::CNormalListenerConnection(SOCKET sock, int timeout)
{
	m_socket.AttachSocket(sock);
	m_socket.SetTimeout(timeout);
}

CNormalListenerConnection::~CNormalListenerConnection(void)
{
	Close();
}


/////////////////////////////////////////////////////////////////////
//	IClientConnection
/////////////////////////////////////////////////////////////////////
/*!
	
*/
void CNormalListenerConnection::AttacheToThread(IServerToolIIPtr serverTool, IConnectionThreadStatusIIPtr threadStatus)
{
	m_threadStatus = threadStatus;
	m_socket.SetExBreakEvent(m_threadStatus->GetBreakEvent());
}

/*!
	ؒf
*/
void CNormalListenerConnection::Close()
{
	m_socket.Close();
}


/*!
	NCAg̎擾
*/
void CNormalListenerConnection::GetClientInfo(CContextClientInfo info)
{
	//	NCAg
	//	zXg͎ݒ肳Ȃ
	info.SetAcceptedPort(m_socket.GetPort());
	info.SetAcceptedAddress(m_socket.GetAddres());
	info.SetClientPort(m_socket.GetPeerPort());
	info.SetClientAddress(m_socket.GetPeerAddres());
}

/*!
	̐ڑ҂

	\return TRUE->oAFALSE->^CAEg
*/
int CNormalListenerConnection::WaitNextConnection(int waitTime)
{
	return m_socket.WaitNextRequest(waitTime);
}

/*!
	ڑ擾
*/
int CNormalListenerConnection::IsConnecting()
{
	return !m_socket.IsDisconnect();
}


/////////////////////////////////////////////////////////////////////
//	IFilter
/////////////////////////////////////////////////////////////////////
/*!
	wb_M(throw)
*/
void CNormalListenerConnection::RecvRequestHeader(CString &requestHeader)
{
	//	wb_M
	if(m_socket.RecvProtocolHeader(requestHeader, END_HEADER, MAX_HEADER_SIZE, FALSE))
		throw CConnectionErrorException("HTTPwb_̎MɎs܂: " + m_socket.GetLastErrorString());
}


/*!
	{fBM(throw)
*/
int CNormalListenerConnection::RecvRequestBody(CBinaryData &body, int leftSize)
{
	//	M
	int recved = m_socket.RecvBinary(body, leftSize);
	if(m_socket.GetLastError())
		throw CConnectionErrorException("f[^̎MɎs܂: " + m_socket.GetLastErrorString());

	return(recved);
}


/*!
	wb_𑗐M(throw)
*/
void CNormalListenerConnection::SendResponseHeader(CString &responseHeader)
{
	//	X|Xwb_M
	m_socket.SendString(responseHeader);
	if(m_socket.GetLastError())
		throw CConnectionErrorException("HTTPwb_̑MɎs܂: " + m_socket.GetLastErrorString());
}

/*!
	{fB𑗐M(throw)
*/
void CNormalListenerConnection::SendResponseBody(CBinaryData &body)
{
	//	M
	m_socket.SendBinary(body);
	if(m_socket.GetLastError())
		throw CConnectionErrorException("f[^̑MɎs܂: " + m_socket.GetLastErrorString());
}


