/*!
	IResponse

	X|Xׂ̎C^tF[X
*/

#pragma once
#include "InternalInterfaceTemplate.h"
#include "Context.h"
#include "IServerTool.h"
#include "IConnectionControl.h"
#include "IConnectionThreadStatus.h"

//!	C^[tF[X`
class IResponse;
class IResponseFactory;
class IResponseContext;
DEFINE_INTERNAL_INTERFACE(IResponse);
DEFINE_INTERNAL_INTERFACE(IResponseFactory);
DEFINE_INTERNAL_INTERFACE_NOWRAP(IResponseContext);

/*!
	X|XReLXg
*/
class IResponseContext
{
public:
	virtual ~IResponseContext() {};

	//!	C^tF[X擾
	virtual IResponseContextIIPtr GetIResponseContext() = 0;

	//!	T[oc[擾
	virtual IServerToolIIPtr GetIServerTool() = 0;

	//!	XbhXe[^X擾
	virtual IConnectionThreadStatusIIPtr GetIConnectionThreadStatus() = 0;

	//!	ڑ擾
	virtual IConnectionControlIIPtr GetIConnectionControl() = 0;
		
	//!	ReLXg擾
	virtual CContext GetContxet() = 0;
};



/*!
	X|XNX
*/
class IResponseFactory
{
public:
	virtual ~IResponseFactory(void)
	{
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void StartFactory(IServerToolIIPtr serverTool) = 0;

	//!	~
	virtual void StopFactory() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int IsYourRequest(CContext context) = 0;

	//!	X|X擾
	virtual IResponseIIPtr GetResponse() = 0;
};


/*!
	X|XNX
*/
class IResponse
{
public:
	virtual ~IResponse(void)
	{
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void Start(IResponseContextIIPtr responseContext) = 0;

	//!	~(OցI)
	virtual void Stop(IResponseContextIIPtr responseContext) = 0;

	//!	X|X擾(Kstatic̈ɐ錾Ȃ΂ȂȂ)
	virtual LPCTSTR GetResponseName() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_ݒ
	virtual void SetRequest(IResponseContextIIPtr responseContext, CContextRequestInfo requestInfo) = 0;

	//!	NGXg{fBݒ(JԂ)
	virtual void SetRequestBody(IResponseContextIIPtr responseContext, CBinaryData &body) = 0;

	//!	NGXg
	virtual void EndRequest(IResponseContextIIPtr responseContext) = 0;


	//!	X|X
	virtual void BuildResponse(IResponseContextIIPtr responseContext) = 0;


	//!	X|Xwb_擾
	virtual void GetResponse(IResponseContextIIPtr responseContext, CContextResponseInfo responseInfo) = 0;

	//!	X|X{fB擾
	virtual int GetResponseBody(IResponseContextIIPtr responseContext, CBinaryData &body, int blockSize) = 0;

	//!	X|X
	virtual void EndResponse(IResponseContextIIPtr responseContext) = 0;
};

