#include "StdAfx.h"
#include "CGIProcess.h"
#include "ServerException.h"
#include "TextTools.h"
#include "TextFormatter.h"
#include "ThreadSkeleton.h"
#include "IntervalTimer.h"

CCGIProcess::CCGIProcess(void)
{
	m_envAccess	= m_envRoot.GetAccess("Env");
}

CCGIProcess::~CCGIProcess(void)
{
}

///////////////////////////////////////////////////////////////////////////
//	s
///////////////////////////////////////////////////////////////////////////
/*!
	CGIR}hC擾
*/
CString CCGIProcess::CreateCGICommandLine(CContext context, CCGICommand cgiCommand)
{
	CTextFormatter	formatter;

	//	uǉ
	formatter.AddKey("FilePath", context.GetTargetInfo().GetTarget());
	formatter.AddKey("Query", context.GetRequestInfo().GetQuery());

	//	擾
	return formatter.GetFormattedString(cgiCommand.GetCGICommand());
}



/*!
	wb_擾

*/
CString CCGIProcess::GetHeaderBlock(CBinaryData &readBuffer)
{
	//	wb_擾
	CString header = readBuffer.GetCString();

	//	wb_
	int index1 = header.Find("\r\n\r\n");
	int index2 = header.Find("\n\n");

	if(index1 != -1 && (index2 == -1 || index2 > index1))
	{
		//	wb_폜
		readBuffer.Remove(0, index1+4);

		//	wb_擾
		header = header.Left(index1);
		return(header);
	}

	if(index2 != -1)
	{
		//	wb_폜
		readBuffer.Remove(0, index2+2);

		//	wb_擾
		header = header.Left(index2);
		header.Replace("\r\n", "\n");
		header.Replace("\n", "\r\n");
		return(header);
	}
	return("");
}


/*!
	wb_
*/
void CCGIProcess::ParseCGIHeader(CString headerBlock, CCGIHeader headerOption)
{
	CString line;
	while(CTextTools::GetLine(headerBlock, line))
	{
		//	: 擾
		int index = line.Find(":");
		if(index == -1)
			continue;

		//	؂o
		CString key = line.Left(index);
		CString data = line.Mid(index + 1);
		key.Trim();
		data.Trim();

		//	ݒ
		if(key.CompareNoCase("Status") == 0)
			headerOption.SetStatus(atoi(data));
		else if(key.CompareNoCase("Content-Type") == 0)
			headerOption.SetContentType(data);
		else if(key.CompareNoCase("Content-Length") == 0)
			headerOption.SetContentLength(CTextTools::strtoi64(data, 10));
		else if(key.CompareNoCase("Location") == 0)
			headerOption.SetLocation(data);
		else
		{
			//	CGI-Extension header
			headerOption.SetExtraHeader(headerOption.GetExtraHeader() + key + ": " + data + "\r\n");
		}
	}
}


///////////////////////////////////////////////////////////////////////////
//	ϐ
///////////////////////////////////////////////////////////////////////////
/*!
	T[oϐǉ
*/
void CCGIProcess::AddServerInfoToEnv(CServerInfo serverInfo)
{

	//	CGI vO NT[o\tgEGA̖Oƃo[WB
	m_envAccess.SetKeyStr("SERVER_SOFTWARE", serverInfo.GetServerSignature());

	//	T[õVOj`
	m_envAccess.SetKeyStr("SERVER_SIGNATURE", CTextTools::GetFormat("<address>%s</address>", serverInfo.GetServerSignature()));

	//	T[õzXgAhCA܂IPAhXB 
	m_envAccess.SetKeyStr("SERVER_NAME", serverInfo.GetServerHostName());

	//	T[ogpCGĨrW
	m_envAccess.SetKeyStr("GATEWAY_INTERFACE", "CGI/1.1");

	//	vgR̖OƃrWB
	m_envAccess.SetKeyStr("SERVER_PROTOCOL", "HTTP/1.1");
}

/*!
	vϐǉ
*/
void CCGIProcess::AddRequestInfoToEnv(CContext context)
{
	/*
		NCAg{
	*/
	//	T[õAhX
	m_envAccess.SetKeyStr("SERVER_ADDR", context.GetClientInfo().GetAcceptedAddress());

	//	T[õ|[gԍB 
	m_envAccess.SetKeyInt("SERVER_PORT", context.GetClientInfo().GetClientPort());



	/*
		NGXg{
	*/
	CContextRequestInfo	requestInfo = context.GetRequestInfo();

	//	NGXg𑗐M@i\bhjBGETPOSTȂǁB 
	m_envAccess.SetKeyStr("REQUEST_METHOD", requestInfo.GetMethod());

	//	POSTW͂ɑMꂽf[^̃oCgB 
	m_envAccess.SetKeyInt64("CONTENT_LENGTH", requestInfo.GetRequestOption().GetContentLength());
 
	//	POSTPUTȂǂ̃NGɓYtꂽf[^MIME^CvB
	m_envAccess.SetKeyStr("CONTENT_TYPE", requestInfo.GetRequestOption().GetContentType());

	//	NGƂđꂽURL̃NGX`( ? )ȍ~̏Bf[^́wURLGR[hxĂ܂B 
	m_envAccess.SetKeyStr("QUERY_STRING", requestInfo.GetQuery());

	//	URI
	m_envAccess.SetKeyStr("REQUEST_URI", requestInfo.GetURL());


	/*
		pXɊւ
	*/
	//	zpX
	m_envAccess.SetKeyStr("SCRIPT_NAME", requestInfo.GetObject());

	//	΃pXB
	m_envAccess.SetKeyStr("SCRIPT_FILENAME", BackSlashToSlash(context.GetTargetInfo().GetTarget()));

	//	GNXgpX
	if(context.GetTargetInfo().ExtraPathIsSet())
	{
		CString	extraPath = context.GetTargetInfo().GetExtraPath();

		//	GNXgpX
		m_envAccess.SetKeyStr("PATH_INFO", extraPath);

		//	GNXgpX̃[JpXϊ
		m_envAccess.SetKeyStr("PATH_TRANSLATED", BackSlashToSlash(context.GetTargetInfo().GetTarget()) + extraPath);

		//	XNvgC
		CString	uri = requestInfo.GetURL();
		if(uri.GetLength() > extraPath.GetLength())
			uri = uri.Left(uri.GetLength() - extraPath.GetLength());
		m_envAccess.SetKeyStr("SCRIPT_NAME", uri);
	}

	/*
		NCAgɊւϐ̃Xg
	*/
	//	[gzXgIPAhXB 
	m_envAccess.SetKeyStr("REMOTE_ADDR", context.GetClientInfo().GetClientAddress());

	//	[gzXg̃zXgB 
	m_envAccess.SetKeyStr("REMOTE_HOST", context.GetClientInfo().GetClientHostName());

	//	[gzXg̃|[gB 
	m_envAccess.SetKeyInt("REMOTE_PORT", context.GetClientInfo().GetClientPort());



	/*
		[UɊւϐ̃Xg
	*/
	//	[UF؂ƂɎgpF؃\bhBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂlB 
	m_envAccess.SetKeyStr("AUTH_TYPE", "basic");

	//	[U̔FؖBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂl܂B 
	m_envAccess.SetKeyStr("REMOTE_USER", requestInfo.GetUser());

	//	[U̔FؖBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂl܂B 
	m_envAccess.SetKeyStr("AUTH_USER", requestInfo.GetUser());

 	//	[ŨpX[hBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂl܂B 
	m_envAccess.SetKeyStr("AUTH_PASSWORD", requestInfo.GetPasswd());

	//	[U̔Fؖ 
	m_envAccess.SetKeyStr("PHP_AUTH_USER", requestInfo.GetUser());

 	//	[ŨpX[h
	m_envAccess.SetKeyStr("PHP_AUTH_PW", requestInfo.GetPasswd());


	/*
		NGXgwb_̕ϊ
	*/
	CStringArray keyList;
	requestInfo.GetRequestOption().GetAllKey(keyList);

	//	ϊ
	for(int i=0;i<keyList.GetSize();i++)
	{
		CString	key = keyList[i];
		m_envAccess.SetKeyStr("HTTP_" + key.MakeUpper(), requestInfo.GetRequestOption().GetKeyStr(keyList[i], ""));
	}
}


/*!
	XNvgpXݒiSSIpj

	C֐̂߁AŌɌĂяoKv
*/
void CCGIProcess::ChangeScriptPath(CString virtualPath, CPathInfo pathInfo)
{
	//	zpX
	m_envAccess.SetKeyStr("SCRIPT_NAME", virtualPath);

	//	΃pXB
	int	serverPathCount = pathInfo.GetServerPath().GetLength();
	m_envAccess.SetKeyStr("SCRIPT_FILENAME", BackSlashToSlash(pathInfo.GetLocalPath() + virtualPath.Mid(serverPathCount)));


	/*!
		֌W̕ϐ폜
	*/
	//	POSTW͂ɑMꂽf[^̃oCgB 
	m_envAccess.DeleteKey("CONTENT_LENGTH");
 
	//	POSTPUTȂǂ̃NGɓYtꂽf[^MIME^CvB
	m_envAccess.DeleteKey("CONTENT_TYPE");

	//	NGƂđꂽURL̃NGX`( ? )ȍ~̏Bf[^́wURLGR[hxĂ܂B 
	m_envAccess.DeleteKey("QUERY_STRING");

	//	GNXgpX
	m_envAccess.DeleteKey("PATH_INFO");

	//	GNXgpX̃[JpXϊ
	m_envAccess.DeleteKey("PATH_TRANSLATED");
}

