#pragma once

#include <comutil.h>

/*!
	oCif[^ۉNX

	char[]`̃oCif[^Ǘ
	TCYŒ
*/
class CBinaryData
{
public:
	CBinaryData(int allocSize = 0);
	CBinaryData(CBinaryData &other);
	virtual ~CBinaryData(void);

	////////////////////////////////////////////////////////////////////////////////////////
	//	m
	////////////////////////////////////////////////////////////////////////////////////////
	//!	̈TCYύX
	void ReSize(int size);

	//! ʂݒ
	void SetGrowSize(int size) { m_growSize = size; };

	//! TCY擾
	int GetSize() {	return(m_usingSize); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	폜
	////////////////////////////////////////////////////////////////////////////////////////
	//! 폜
	int Remove(int start, int size);

	//! ɂ
	void Empty() { ReSize(0); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	|C^ANZX
	////////////////////////////////////////////////////////////////////////////////////////
	//!	擪|C^擾
	char * GetPtr() { return m_buffer; };

	//! char* ɕϊ
	operator char*() { return GetPtr(); };

	//! unsigned char* ɕϊ
	operator unsigned char*()  { return (unsigned char *)GetPtr(); };

	//! CString ɕϊ
	operator CString() { return GetCString(); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////////////
	//!	㏑(KvȂ΁Aobt@ǉ)
	void OverwriteData(int startOffset, char *data, int len);

	//!	ǉ
	void Append(char *data,int size);

	//!	ǉ(CString)
	void AppendString(CString &str)			{ Append(str.GetBuffer(0), str.GetLength()); str.ReleaseBuffer(); };

	//!	ǉ(CBinaryData)
	void AppendBinary(CBinaryData &data)	{ Append(data.GetPtr(), data.GetSize()); };

	//!	ǉ(char)
	void AppendByte(char val)				{ Append(&val, 1); };

	//!	ǉ(short)
	void AppendWord(short val)				{ Append((char *)&val, 2); };

	//!	ǉ(long)
	void AppendDoubleWord(long val)			{ Append((char *)&val, 4); };


	////////////////////////////////////////////////////////////////////////////////////////
	//	ϊ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	CString
	CString GetCString();

	//!	UTF16->UTF8
	static void UTF16ToUTF8(_bstr_t &utf16, CBinaryData &uft8);

	//!	UTF8->UTF16
	static void UTF8ToUTF16(CBinaryData &uft8, _bstr_t &utf16);

	////////////////////////////////////////////////////////////////////////////////////////
	//	t@C
	////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^ۑ
	int SaveToFile(CString path);

	//!	Sēǂݍ
	int LoadFromFile(CString path);

protected:
	////////////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////////////
	//!	
	void InitInternal();

	////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	obt@{
	char	*m_buffer;

	//! obt@TCY
	int		m_usingSize;

	//! mۍς݃obt@TCY
	int		m_bufferSize;

	//! TCY
	int		m_growSize;
};

