#include "StdAfx.h"
#include "BinaryData.h"

#pragma comment(lib, "comsuppw.lib")

//	WgTCY
#define	DEFAULT_GROW_SIZE	32768

////////////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////////////
/*!
	W
*/
CBinaryData::CBinaryData(int allocSize)
{
	InitInternal();
	ReSize(allocSize);
}

/*!
	Rs[
*/
CBinaryData::CBinaryData(CBinaryData &other)
{
	InitInternal();
	ReSize(other.GetSize());

	memmove(m_buffer, other.GetPtr(), other.GetSize());
}

/*!
	fXgN^
*/
CBinaryData::~CBinaryData(void)
{
	if(m_buffer)
		delete m_buffer;
	InitInternal();
}


/*!
	
*/
void CBinaryData::InitInternal()
{
	m_buffer = NULL;
	m_bufferSize = 0;
	m_usingSize = 0;
	SetGrowSize(DEFAULT_GROW_SIZE);
}


////////////////////////////////////////////////////////////////////////////////////////
//	m
////////////////////////////////////////////////////////////////////////////////////////
/*!
	̈TCYύX
*/
void CBinaryData::ReSize(int size)
{
	//	NA
	if(size == 0)
	{
		if(m_buffer)
			delete m_buffer;
		m_buffer = NULL;
		m_bufferSize = 0;
		m_usingSize = 0;
		return;
	}

	//	m
	if(m_buffer == NULL || size > m_bufferSize)
	{
		int allocSize = (size / m_growSize + 1) * m_growSize;
		char *temp = new char[allocSize];
		int	transSize = m_bufferSize;

		//	]
		if(m_buffer != NULL)
		{
			if(m_bufferSize > size)
				transSize = size;

			memmove(temp, m_buffer, transSize);
			delete m_buffer;
		}

		//	ݒ
		m_buffer = temp;
		m_bufferSize = allocSize;
	}
	m_usingSize = size;
}


////////////////////////////////////////////////////////////////////////////////////////
//	폜
////////////////////////////////////////////////////////////////////////////////////////
/*!
	폜
*/
int CBinaryData::Remove(int start, int size)
{
	if(start < 0 || size < 0 || start + size > m_usingSize)
		return(-1);

	memmove(GetPtr() + start,GetPtr() + size,m_usingSize - (start + size));
	m_usingSize = m_usingSize - size;
	return(0);
}

////////////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////////////
/*!
	㏑(KvȂ΁Aobt@ǉ)
*/
void CBinaryData::OverwriteData(int startOffset, char *data, int len)
{
	if(startOffset + len >= m_usingSize)
		ReSize(startOffset + len);

	memmove(m_buffer + startOffset, data, len);
}

/*!
	ǉ
*/
void CBinaryData::Append(char *data,int size)
{
	int	oldSize = GetSize();
	ReSize(size + oldSize);

	memmove(GetPtr() + oldSize, data, size);
}



////////////////////////////////////////////////////////////////////////////////////////
//	ϊ
////////////////////////////////////////////////////////////////////////////////////////
/*!
	CString
*/
CString CBinaryData::GetCString()
{
	CString ret;
	memcpy(ret.GetBuffer(m_usingSize), m_buffer, m_usingSize);
	ret.ReleaseBufferSetLength(m_usingSize);

	return(ret);
}

/*!
	UTF16->UTF8
*/
void CBinaryData::UTF16ToUTF8(_bstr_t &utf16, CBinaryData &uft8)
{
	//	UTF8֕ϊ
	int mbLen = WideCharToMultiByte(CP_UTF8, 0, utf16.GetBSTR(), utf16.length(), NULL, 0, NULL, NULL);

	uft8.ReSize(mbLen);
	WideCharToMultiByte(CP_UTF8, 0, utf16.GetBSTR(), utf16.length(), uft8.GetPtr(), uft8.GetSize(), NULL, NULL);
}

/*!
	UTF8->UTF16
*/
void CBinaryData::UTF8ToUTF16(CBinaryData &uft8, _bstr_t &utf16)
{
	int mbLen = MultiByteToWideChar(CP_UTF8, 0, uft8.GetPtr(), uft8.GetSize(), NULL,0);

	wchar_t	*wstr = new wchar_t[mbLen + 1];
	MultiByteToWideChar(CP_UTF8, 0, uft8.GetPtr(), uft8.GetSize(), wstr, mbLen);
	wstr[mbLen] = 0;

	utf16 = wstr;
}

//////////////////////////////////////////////////////////////////////
// ۑ
//////////////////////////////////////////////////////////////////////
/*!
	t@C֕ۑ

	\param path		pX
*/
int CBinaryData::SaveToFile(CString path)
{
	FILE	*out;
	if(fopen_s(&out ,path,"wb") != 0)
		return(-1);

	fwrite(GetPtr(),GetSize(),1,out);
	fclose(out);
	return(0);
}

/*!
	t@Cǂݏo

	\param path		pX
*/
int CBinaryData::LoadFromFile(CString path)
{
	FILE	*out;
	if(fopen_s(&out ,path,"rb") != 0)
		return(-1);
	
	fseek(out,0,SEEK_END);
	long	len = ftell(out);
	fseek(out,0,SEEK_SET);

	ReSize(len);
	fread(GetPtr(),GetSize(),1,out);
	fclose(out);
	return(0);
}

