import subprocess 

class Interface() :

    def yesnoback(self, _strs) :
        """
        str may be list of string
        yes  : returns True
        no   : returns False
        back : returns None
        """
        pass

    def status(self, _task_name, _i, _num) :
        pass

    def show(self, _str) :
        pass

    def choose(self, _num_of_choices) :
        """
        Enter "exit" ot exit.
           In this case, this returns False
        """
        pass

class CUI(Interface) :

    def yesnoback(self, _strs) :
        
        while(True) :

            if len(_strs[0]) >= 2 :

                for str in _strs :
                    print(str, end="")

            else :
                print(_strs, end="")

            input_res = input("(y/n) > ")

            if input_res == "y" or input_res == "Y" :
                print("")
                return True
            elif input_res == "n" or input_res == "N" :
                print("")
                return False
            elif input_res == "b" or input_res == "B" :
                print("")
                return None

    def show(self, _str) :

        print("{}: {}".format(_str[0].ljust(25), _str[1]))

    def choose(self, _num_of_choices) :
       
        str = "\nChoose the item you want to change.({}-{}) > ".format(1, _num_of_choices)
        while(True) :

            input_res = input(str)

            if input_res == "exit" :
                print("")
                return False

            try :
                num = int(input_res)
            except ValueError :
                continue

            if (1 <= num) and (num <= _num_of_choices) :
                print("")
                return num

class Zenity(CUI) :

    def __init__(self) :

        self.item_list = None
        
    def yesnoback(self, _strs) :
        
        str = ""

        if len(_strs[0]) >= 2 :

            for tmp in _strs :
                str = str + "\n" + tmp

        else :
            str = _strs

        
        ans = subprocess.call(["zenity", "--question", "--title=Serene Setup Wizard", "--text={}".format(str), "--width=300"], stderr=open("/dev/null", "w"))

        if ans == 0 :
            return True
        else :
            return False


    def show(self, _str) :
        
        if self.item_list is None :

            self.item_list = list()

        self.item_list.append(_str)


    def choose(self, _) :

        str = ["zenity", "--list", "--title=Serene Setup Wizard", "--text", "Choose the item you want to change.", "--height=430", "--width=400", "--column", "No.", "--column", "Item", "--column", "Status", "--print-column=all"]
        

        for i, item in enumerate(self.item_list) :

            str.append("{}".format(i+1))
            str.append("{}".format(item[0]))
            str.append("{}".format(item[1]))

        self.item_list = None
       
        while True :

            tmp = open("/tmp/serene-setup-wizard.tmp", "w")
            ret = subprocess.call(str, stdout=tmp, stderr=open("/dev/null", "w"))
            tmp.close()

            if ret :
                print("")
                return False

            tmp = open("/tmp/serene-setup-wizard.tmp", "r")
            ans = tmp.readline().split("|")[0]
            tmp.close()

            if ans != "" :   
                break
        
        print("")
        return int(ans)

