import styled from 'styled-components';

const buttonSize = 30;

export const ToolbarTextBoxWrapper = styled.div`
  background: ${props => !props.isDarkModeOrPrivateMode ? 'white' : '#252525'};
  border: solid 1px #c1c1c1;
  border-radius: 2px;
  outline: none;
  color: ${props => !props.isDarkModeOrPrivateMode ? 'black' : 'white'};
  font-size: 14.5px;
  /* width: calc((100% - 40px * ${props => props.buttonCount}) - 25px); */
  flex-grow: 4;
  height: 30px;
  margin: 5px;
  padding: 0px;
  position: relative;
  box-sizing: border-box;
  &:hover, &:focus {
    box-shadow: 0 5px 10px -3px rgba(0,0,0,.15), 0 0 3px rgba(0,0,0,.1);
    transition: 0.2s;
  }

  div:first-child,
  div:last-child {
    width: ${buttonSize}px;
    height: 100%;
    margin: 0px;
    position: absolute;
  }

  div:first-child {
    left: 0px;
  }

  div:last-child {
    right: 0px;
  }
`;

export const ToolbarTextBox = styled.input`
  width: calc(100% - (${buttonSize}px * 2));
  height: 100%;
  margin: 0px;
  padding: 3px 5px;
  left: ${buttonSize}px;
  right: ${buttonSize}px;
  position: absolute;
  box-sizing: border-box;
  outline: none;
  cursor: initial;
  background: unset;
  border: none;
  border-left: solid 1px #c1c1c1;
  border-right: solid 1px #c1c1c1;
`;