import React, { Component } from 'react';

import Window from './Components/Window';
import WindowButtons from './Components/WindowButtons';
import WindowButton from './Components/WindowButton';
import WindowContent from './Components/WindowContent';
import TitleBar from './Components/TitleBar';
import Tabs from './Components/Tabs';
import { Tab, TabTitle, TabCloseButton } from './Components/Tab';
import TabButton from './Components/TabButton';
import TabContent from './Components/TabContent';
import ToolBar from './Components/ToolBar';
import ToolBarButton from './Components/ToolBarButton';
import ToolBarTextBox from './Components/ToolBarTextBox';
import ContentWrapper from './Components/ContentWrapper';

import WindowMinimizeIcon from './Resources/windows/minimize.svg';
import WindowMaximizeIcon from './Resources/windows/maximize.svg';
import WindowCloseIcon from './Resources/windows/close.svg';

import BackIcon from './Resources/arrow_back.svg';
import ForwardIcon from './Resources/arrow_forward.svg';
import ReloadIcon from './Resources/reload.svg';
import HomeIcon from './Resources/home.svg';
import MoreIcon from './Resources/more.svg';
import AddIcon from './Resources/add.svg';
import CloseIcon from './Resources/close.svg';

const { remote, ipcRenderer, shell } = window.require('electron');
const systemPreferences = remote.systemPreferences;

const platform = require('electron-platform');

class Authentication extends Component {
	constructor(props) {
		super(props);
		this.state = {
			userName: '',
			passWord: ''
		};

		document.title = '認証';
	}

	submit = () => {
		const username = this.state.userName;
		const password = this.state.passWord;
		ipcRenderer.send("authorization", { username, password });
	}

	render() {
		return (
			<Window color={platform.isWin32 || platform.isDarwin ? `#${systemPreferences.getAccentColor()}` : `#353535`}>
				<TitleBar color={platform.isWin32 || platform.isDarwin ? `#${systemPreferences.getAccentColor()}` : `#353535`}>
					<WindowButtons>
						<WindowButton isClose={true} onClick={() => { remote.getCurrentWindow().close(); }}>
							<svg name="TitleBarClose" width="12" height="12" viewBox="0 0 12 12">
								<polygon fill="#ffffff" fill-rule="evenodd" points="11 1.576 6.583 6 11 10.424 10.424 11 6 6.583 1.576 11 1 10.424 5.417 6 1 1.576 1.576 1 6 5.417 10.424 1"></polygon>
							</svg>
						</WindowButton>
					</WindowButtons>
				</TitleBar>
				<WindowContent>
					<div style={{ width: '100%', height: '100%', padding: 5 }}>
						<label style={{ whiteSpace: 'normal' }}>このサイトにログインするための認証情報を入力してください。</label>
						<label style={{ marginBottom: 0 }}>ユーザー名</label>
						<input type="text" value={this.state.userName} onChange={(e) => { this.setState({ userName: e.target.value }); }} style={{ width: '100%', cursor: 'initial' }} />
						<label style={{ marginBottom: 0 }}>パスワード</label>
						<input type="password" value={this.state.passWord} onChange={(e) => { this.setState({ passWord: e.target.value }); }} style={{ width: '100%', cursor: 'initial'}} />
						<button onClick={() => { this.close(); }} style={{ position: 'absolute', bottom: 5, left: 5, width: '48%' }}>キャンセル</button>
						<button onClick={this.submit.bind(this)} style={{ position: 'absolute', bottom: 5, right: 5, width: '48%' }}>送信</button>
					</div>
				</WindowContent>
			</Window>
		);
	}
}

export default Authentication;