const pkg = require(`${__dirname}/../package.json`);
const protocolStr = 'flast';
const fileProtocolStr = `${protocolStr}-file`;

module.exports = {
    window: {
        titleBar: {
            tab: {
                close: 'このタブを閉じる',
                new: '新しいタブを開く'
            },
            buttons: {
                minimize: '最小化',
                maximize: {
                    maximize: '最大化',
                    restore: '元に戻す (縮小)'
                },
                close: '閉じる'
            }
        },
        toolBar: {
            back: '前のページに戻る (Alt+Left)',
            forward: '次のページに進む (Alt+Right)',
            reload: {
                reload: '再読み込み (Ctrl+R)',
                stop: '読み込み中止'
            },
            home: 'ホームページに移動',
            addressBar: {
                info: {
                    info: 'このページの情報',
                    clicked: {
                        internal: `保護された ${pkg.name} ページを表示しています`,
                        secure: 'このサイトへの接続は保護されています',
                        insecure: 'このサイトへの接続は保護されていません'
                    }
                },
                bookmark: {
                    add: 'ブックマークに追加',
                    remove: 'ブックマークから削除',
                    clicked: {
                        add: 'ブックマークに追加しました',
                        remove: 'ブックマークから削除しました',
                        addPrivate: 'プライベート ブックマークに追加しました',
                        removePrivate: 'プライベート ブックマークから削除しました'
                    }
                },
            },
            extensions: {
                adBlock: '{replace}個の広告をブロックしました',
                feedback: 'フィードバックの送信'
            },
            menu: {
                menu: 'メニュー',
                menus: {
                    newTab: '新しいタブ',
                    newWindow: '新しいウィンドウ',
                    openPrivateWindow: 'プライベート ウィンドウを開く',
                    history: '履歴',
                    downloads: 'ダウンロード',
                    bookmarks: 'ブックマーク',
                    app: {
                        app: 'アプリ',
                        list: 'アプリ リスト',
                        install: '{title} をインストール',
                        uninstall: '{title} をアンインストール',
                        run: '{title} を起動'
                    },
                    print: '印刷',
                    find: '検索',
                    settings: '設定',
                    help: 'ヘルプ',
                    close: '閉じる'
                }
            }
        },
        view: {
            contextMenu: {
                link: {
                    newTab: '新しいタブで開く',
                    newWindow: '新しいウィンドウで開く',
                    openPrivateWindow: 'プライベート ウィンドウで開く',
                    copy: 'リンクをコピー'
                },
                image: {
                    newTab: '新しいタブで画像を開く',
                    saveImage: '名前を付けて画像を保存',
                    copyImage: '画像をコピー',
                    copyLink: '画像アドレスをコピー'
                },
                editable: {
                    undo: '元に戻す',
                    redo: 'やり直す',
                    cut: '切り取り',
                    copy: 'コピー',
                    paste: '貼り付け',
                    selectAll: 'すべて選択'
                },
                selection: {
                    copy: 'コピー',
                    textSearch: '{name}で「{text}」を検索'
                },
                back: '戻る',
                forward: '進む',
                reload: {
                    reload: '再読み込み',
                    stop: '読み込み中止'
                },
                floatingWindow: 'Floating Window (Beta)',
                savePage: 'ページの保存',
                print: '印刷',
                viewSource: 'ページのソースを表示',
                devTool: 'デベロッパー ツール'
            }
        }
    }
}