'use strict';

const builder = require('electron-builder');
const fs = require('fs');
const packageJson = JSON.parse(fs.readFileSync('./app/package.json', 'utf8'));

builder.build({
    platform: 'win',
    config: {
        'appId': `org.aoichaan0513.${packageJson.name}`,
        'productName': packageJson.name,
        'asar': true,
        'nsis': {
            'installerIcon': './static/icon.ico',
            'uninstallerIcon': './static/icon.ico'
        },
        'win': {
            'target': 'nsis',
            'icon': './static/icon.ico',
        },
    },
});