'use strict';

const builder = require('electron-builder');
const fs = require('fs');
const packageJson = JSON.parse(fs.readFileSync('./app/package.json', 'utf8'));

builder.build({
    platform: 'mac',
    config: {
        'appId': `org.aoichaan0513.${packageJson.name}`,
        'productName': packageJson.name,
        'asar': true,
        'nsis': {
            'installerIcon': './static/icon.ico',
            'uninstallerIcon': './static/icon.ico'
        },
        'mac': {
            'target': 'dmg',
            'icon': './static/icon.ico',
        },
    },
});