// TreeItem.cpp : CTreeItem ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "TreeItem.h"
#include "objectmap.h"
#include <list>
using namespace std;


/////////////////////////////////////////////////////////////////////////////
// CTreeItem

STDMETHODIMP CTreeItem::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ITreeItem
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

BOOL CTreeItem::DeleteTreeItemWithData(HWND hWnd,HTREEITEM hItem)
{
	HTREEITEM hRoot = hItem;
	list<HTREEITEM> lst;
	lst.push_back(hItem);
	while(!lst.empty()){
		 hItem = lst.front();
		 lst.pop_front();
		 while(hItem){
			 HTREEITEM hChild = TreeView_GetChild(hWnd,hItem);
			 if(hChild){
				 // qO[v悤ɃX^bN
				 lst.push_back(hChild);
			 }
			 // ̃ACeɊ֘AÂꂽIuWFNg
			 TVITEM itm = {0};
			 itm.mask  = TVIF_PARAM;
			 itm.hItem = hItem;
			 if(TreeView_GetItem(hWnd,&itm) && itm.lParam){
				IUnknown* pUnk = (IUnknown*)itm.lParam;
				pUnk->Release();
				itm.lParam = NULL;
				TreeView_SetItem(hWnd,&itm);
			 }	
			 // ̃ACeT
			 if(hRoot == hItem){
				 // JnʒǔZ͒TĂ͂ȂȂ
				 hItem = NULL;
			 }
			 else{
				 hItem = TreeView_GetNextSibling(hWnd,hItem);
			 }
		 }
	}
	TreeView_DeleteItem(hWnd,hRoot);
	return true;
}

void CTreeItem::CreateTreeItem(HWND hWnd, HTREEITEM hParent, LPCSTR text, IUnknown **punkVal)
{
	// ACeۗLAzz𐶐
	IUnknown* pUnk = NULL;
	CComObject<CObjectMap>* pMap = NULL;
	if(pMap->CreateInstance(&pMap) == S_OK){
		pMap->QueryInterface(IID_IUnknown,(void**)&pUnk);
	}
	// }ACe̒`
	TVINSERTSTRUCT is = { 0 };
	is.hParent       = hParent;
	is.hInsertAfter  = TVI_LAST;
	is.item.mask     = TVIF_TEXT | TVIF_PARAM;
	is.item.pszText  = (LPSTR)text;
	is.item.cchTextMax = lstrlen(text);
	is.item.lParam   = (LPARAM)pUnk;

	HTREEITEM hNewItem = TreeView_InsertItem(hWnd,&is);
	if(hNewItem){
		// ACeւ̃IuWFNg쐬
		CComObject<CTreeItem>* pItem = NULL;
		if(pItem->CreateInstance(&pItem) == S_OK){
			pItem->SetParam(hWnd,hNewItem);
			pItem->QueryInterface(IID_IUnknown,(void**)punkVal);
		}
	}
}

STDMETHODIMP CTreeItem::IsValid(BOOL *pResult)
{
	*pResult = (m_hItem != NULL)?VB_TRUE:VB_FALSE;
	return S_OK;
}
