// ObjectMap.cpp : CObjectMap ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "ObjectMap.h"
#include "profilesection.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CObjectMap


STDMETHODIMP CObjectMap::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IObjectMap
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CObjectMap::FindNear(VARIANT key, VARIANT *pVal)
{
	CComVariant varName;
	::VariantInit(pVal);
	if(varName.ChangeType(VT_BSTR,&key) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	VariantMap::iterator p = m_mapVariant.lower_bound(varName.bstrVal);
	if(p != m_mapVariant.end()){
		// ꂽ
		CComVariant findkey((LPCWSTR)p->first);
		findkey.ChangeType(VT_BSTR);
		findkey.Detach(pVal);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::get_NearValue(VARIANT key, VARIANT *pVal)
{
	CComVariant varName;
	::VariantInit(pVal);
	if(varName.ChangeType(VT_BSTR,&key) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	VariantMap::iterator p = m_mapVariant.lower_bound(varName.bstrVal);
	if(p != m_mapVariant.end()){
		// ꂽ
		VariantCopy(pVal,&p->second);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::get_Value(VARIANT key, VARIANT *pVal)
{
	CComVariant varName;
	::VariantInit(pVal);
	if(varName.ChangeType(VT_BSTR,&key) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if(p != m_mapVariant.end()){
		// ꂽ
		VariantCopy(pVal,&p->second);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::put_Value(VARIANT key, VARIANT newVal)
{
	CComVariant varName;
	if(varName.ChangeType(VT_BSTR,&key) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if(p != m_mapVariant.end()){
		// 
		VariantCopy(&p->second,&newVal);
	}
	else{
		// VK
		VARIANT tmp;
		::VariantInit(&tmp);
		VariantCopy(&tmp,&newVal);
		m_mapVariant.insert(pair<_bstr_t,VARIANT>(varName.bstrVal,tmp));
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::get_Count(long *pVal)
{
	*pVal = m_mapVariant.size();
	return S_OK;
}

STDMETHODIMP CObjectMap::Clear()
{
	//VARIANT̃NAƘAzz̉
	VariantMap::iterator p = m_mapVariant.begin();
	while(p != m_mapVariant.end()){
		::VariantClear(&p->second);
		p++;
	}
	m_mapVariant.clear();
	return S_OK;
}


STDMETHODIMP CObjectMap::Duplicate(IUnknown** punkVal)
{
	*punkVal = NULL;
	CComObject<CObjectMap>* pMap = NULL;
	if(pMap->CreateInstance(&pMap) == S_OK){
		// ݂̃IuWFNg𕡐
		VariantMap::iterator p = m_mapVariant.begin();
		while(p != m_mapVariant.end()){
			CComVariant key((LPCWSTR)p->first);
			key.ChangeType(VT_BSTR);
			pMap->put_Value(key,p->second);
			p++;
		}
		pMap->QueryInterface(IID_IUnknown,(void**)punkVal);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::CreateMap(IUnknown** punkVal)
{
	*punkVal = NULL;
	CComObject<CObjectMap>* pMap = NULL;
	if(pMap->CreateInstance(&pMap) == S_OK){
		pMap->QueryInterface(IID_IUnknown,(void**)punkVal);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::get__NewEnum(IUnknown **pVal)
{
	int mx = m_mapVariant.size();
	VARIANT* pvarArray = new VARIANT[mx+1];
	// i[Ă閼O̗
	VariantMap::iterator p = m_mapVariant.begin();
	int i = 0;
	while(p != m_mapVariant.end()){
		::VariantInit(&pvarArray[i]);
		pvarArray[i].vt = VT_BSTR;
		pvarArray[i].bstrVal = SysAllocString(p->first);
		p++;
		i++;
	}
	// 񋓃C^[tFCX̐
	CComObject<CComEnumVARIANT>* pCol = NULL;
	if(pCol->CreateInstance(&pCol) == S_OK){
		pCol->AddRef();
		pCol->Init(&pvarArray[0],&pvarArray[mx],pCol,AtlFlagCopy);
		*pVal = pCol;
	}
	// mۂoAg̔j([XsKv)
	i = 0;
	while(i < mx){
		::VariantClear(&pvarArray[i++]);
	}
	delete[]pvarArray;
	return S_OK;
}

STDMETHODIMP CObjectMap::ExpandVariables(VARIANT text, VARIANT env, VARIANT *pVal)
{
	CComVariant varText,varEnv,varResult;
	if(varText.ChangeType(VT_BSTR,&text) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	// ϐWJ邩?
	BOOL bEnv = false;
	if(varEnv.ChangeType(VT_I2,&env) == S_OK){
		bEnv = varEnv.iVal;
	}
	// tF[Y1 : ܂܂ϐ𒲍ĕKvȃobt@TCY߂
	// tF[Y2 ; ۂɓWJ
	DWORD expandsize = 0;
	UINT writeidx    = 0;
	LPWSTR pExpandBuffer = NULL;
	for(int phase = 0;phase < 2;phase++){
		LPCWSTR str = varText.bstrVal;
		UINT length = SysStringLen(varText.bstrVal);
		UINT idx    = 0;
		while(idx < length){
			if(str[idx] == '%'){
				// ϐWJX^[g
				WCHAR name[MAX_PATH] = {0};
				UINT len = 0;
				// A%ɂ%g̏o͂ł邩?
				idx++;
				if(str[idx] == '%'){
					if(phase == 0){
						idx++;
					}
					else{
						pExpandBuffer[writeidx++] = str[idx++];
					}
					continue;
				}
				// ϐ̎o
				while(idx < length && str[idx] != '%'){
					name[len++] = str[idx++];
				}
				name[len] = 0;
				if(str[idx] == '%'){
					idx++;
				}
				// ϐ̎݃`FbN
				VariantMap::iterator p = m_mapVariant.find(name);
				if(p != m_mapVariant.end()){
					// ꂽ
					CComVariant tmp;
					if(tmp.ChangeType(VT_BSTR,&p->second) == S_OK){
						if(phase == 0){
							// tF[Y1̓TCYJEg邾
							expandsize += SysStringLen(tmp.bstrVal);
						}
						else{
							// tF[Y2݈͌ʒuɕϐWJ
							UINT len = SysStringLen(tmp.bstrVal);
							UINT i;
							for(i=0;i<len;i++){
								pExpandBuffer[writeidx++] = tmp.bstrVal[i];
							}
						}
					}
				}
				else if(bEnv){
					// Azzɂ݂͑AϐWJwĂ
					CHAR szName [MAX_PATH] = { 0 };
					CHAR szBuf  [MAX_PATH] = { 0 };
					WCHAR wbuf[MAX_PATH] = { 0 };
					WideCharToMultiByte(GetACP(),0,name,-1,szName,MAX_PATH,NULL,NULL);
					DWORD ret = GetEnvironmentVariable(szName,szBuf,MAX_PATH);
					if(ret && ret < MAX_PATH){
						// ϐꂽ
						if(phase == 0){
							// tG[Y1̓JEg邾
							expandsize += ret;
						}
						else{
							// tF[Y2͎ۂɏ
							MultiByteToWideChar(GetACP(),0,szBuf,ret,wbuf,MAX_PATH);
							UINT i;
							for(i=0;i<ret;i++){
								pExpandBuffer[writeidx++] = wbuf[i];
							}
						}
					}
				}
				continue;
			}
			if(phase == 0){
				// tF[Y1͉Ȃ
				idx++;
			}
			else{
				// tF[Y2̓obt@ɒʏ폑݂
				pExpandBuffer[writeidx++] = str[idx++];
			}
		}
		//
		if(phase == 0){
			// tF[Y1ÎŃobt@TCYB
			pExpandBuffer = new WCHAR[length + expandsize + 1];
		}
		else{
			// tF[Y2ÎŒu
			pExpandBuffer[writeidx] = 0;
			varResult = (LPCWSTR)pExpandBuffer;
			delete[]pExpandBuffer;
		}
	}
	varResult.Detach(pVal);
	return S_OK;
}


STDMETHODIMP CObjectMap::get_IsExist(VARIANT key, BOOL *pVal)
{
	CComVariant varName;
	*pVal = VB_FALSE;
	if(varName.ChangeType(VT_BSTR,&key) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if(p != m_mapVariant.end()){
		// ݂
		*pVal = VB_TRUE;
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::Erase(VARIANT key)
{
	CComVariant varName;
	if(varName.ChangeType(VT_BSTR,&key) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	VariantMap::iterator p = m_mapVariant.find(varName.bstrVal);
	if(p != m_mapVariant.end()){
		m_mapVariant.erase(p);
	}
	return S_OK;
}

STDMETHODIMP CObjectMap::LoadProfile(IUnknown *punkVal)
{
	ISeraphyScriptTools_ProfileSection* pSection = NULL;
	if(punkVal->QueryInterface(IID_ISeraphyScriptTools_ProfileSection,(void**)&pSection) != S_OK){
		return DISP_E_UNKNOWNINTERFACE;
	}
	// 
	CComVariant varArray;
	pSection->GetKeyNames(&varArray);
	if(!(varArray.vt & VT_ARRAY)){
		// Internal Error
		return DISP_E_UNKNOWNINTERFACE;
	}
	// z̏I擾
	long mx = 0;
	HRESULT ret = SafeArrayGetUBound(varArray.parray,1,&mx);
	if(ret != S_OK){
		mx = -1;
	}
	long idx = 0;
	while(idx <= mx){
		CComVariant varKey,varVal;
		if(SafeArrayGetElement(varArray.parray,&idx,&varKey) == S_OK){
			if(pSection->get_Value(varKey,&varVal) == S_OK){
				put_Value(varKey,varVal);
			}
		}
		idx++;
	}
	pSection->Release();
	return S_OK;
}

STDMETHODIMP CObjectMap::SaveProfile(IUnknown *punkVal)
{
	ISeraphyScriptTools_ProfileSection* pSection = NULL;
	if(punkVal->QueryInterface(IID_ISeraphyScriptTools_ProfileSection,(void**)&pSection) != S_OK){
		return DISP_E_UNKNOWNINTERFACE;
	}
	// i[Ă閼O̗
	VariantMap::iterator p = m_mapVariant.begin();
	while(p != m_mapVariant.end()){
		CComVariant varTmp;
		if(varTmp.ChangeType(VT_BSTR,&p->second) == S_OK){
			CComVariant varIdx = (BSTR)p->first;
			pSection->put_Value(varIdx,varTmp);
		}
		p++;
	}
	pSection->Release();
	return S_OK;
}
