// Layer.h : CLayer ̐錾

#ifndef __LAYER_H_
#define __LAYER_H_

#include "resource.h"       // C V{

#include <list>
using namespace std;


/////////////////////////////////////////////////////////////////////////////
// `IuWFNgNX

class CDC
{
public:
	HDC m_hDC;
	BOOL m_bPrinting;
	RECT m_rct;
};

class drawdata
{
public:
	drawdata()
	{
		HWND hWnd = GetDesktopWindow();
		HDC hdc = GetDC(hWnd);
		m_height_mm = GetDeviceCaps(hdc,VERTSIZE) * 10;
		m_height_px = GetDeviceCaps(hdc,VERTRES);
		m_width_mm  = GetDeviceCaps(hdc,HORZSIZE) * 10;
		m_width_px = GetDeviceCaps(hdc,HORZRES);
		ReleaseDC(hWnd,hdc);
	}
	virtual void Destroy() = 0;
	virtual void Draw(CDC hdc) = 0;
	void DPtoLP(CDC& dc,POINT* pt,int cnt)
	{
		long offsetY = 0;
		if(!dc.m_bPrinting){
			offsetY = MulDiv(dc.m_rct.bottom,m_height_mm,m_height_px);
		}
		else{
			offsetY = dc.m_rct.bottom;
		}
		int i;
		for(i=0;i<cnt;i++){
			pt[i].y = offsetY - MulDiv(pt[i].y,m_height_mm,m_height_px);
			pt[i].x = MulDiv(pt[i].x,m_width_mm ,m_width_px );
		}
	}
protected:
	int m_bTextMappingMode;
	long m_height_mm;
	long m_height_px;
	long m_width_mm;
	long m_width_px;
};

class textdata : public drawdata
{
public:
	textdata(long x,long y,LPCSTR text,BOOL mapmode)
	{
		pBuf = new TCHAR[lstrlen(text)+1];
		lstrcpy(pBuf,text);
		m_x = x;
		m_y = y;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete pBuf;
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt = {m_x,m_y};
		if(m_bTextMappingMode){
			SetTextAlign(dc.m_hDC,TA_TOP);
			DPtoLP(dc,&pt,1);
		}
		else{
			SetTextAlign(dc.m_hDC,TA_BASELINE);
		}
		TextOut(dc.m_hDC,pt.x,pt.y,pBuf,lstrlen(pBuf));
	}
protected:
	long m_x;
	long m_y;
	LPTSTR pBuf;
};

class textboxdata : public drawdata
{
public:
	textboxdata(long sx,long sy,long ex,long ey,LPCSTR text,UINT fmt,BOOL mapmode)
	{
		pBuf = new TCHAR[lstrlen(text)+1];
		lstrcpy(pBuf,text);
		m_box.left   = sx;
		m_box.top    = sy;
		m_box.right  = ex;
		m_box.bottom = ey;
		m_fmt = fmt;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete pBuf;
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		RECT box = m_box;
		if(m_bTextMappingMode){
			DPtoLP(dc,(LPPOINT)&box,2);
			SetTextAlign(dc.m_hDC,TA_TOP);
		}
		else{
			SetTextAlign(dc.m_hDC,TA_BASELINE);
		}
		DrawText(dc.m_hDC,pBuf,lstrlen(pBuf),&box,m_fmt);
	}
protected:
	UINT m_fmt;
	RECT m_box;
	LPTSTR pBuf;
};

class linedata : public drawdata
{
public:
	linedata(long sx,long sy,long ex,long ey,BOOL mapmode)
	{
		m_sx = sx;
		m_sy = sy;
		m_ex = ex;
		m_ey = ey;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[2] = {{m_sx,m_sy},{m_ex,m_ey}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,2);
		}
		MoveToEx(dc.m_hDC,pt[0].x,pt[0].y,NULL);
		LineTo(dc.m_hDC,pt[1].x,pt[1].y);
	}
protected:
	long m_sx;
	long m_sy;
	long m_ex;
	long m_ey;
};

class circledata : public drawdata
{
public:
	circledata(long sx,long sy,long radius,BOOL mapmode)
	{
		m_sx = sx;
		m_sy = sy;
		m_radius = radius;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[2]   = {{m_sx ,m_sy},{m_radius ,m_radius}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,2);
		}
		Arc(dc.m_hDC,(pt[0].x-pt[1].x),(pt[0].y-pt[1].x),(pt[0].x+pt[1].x),(pt[0].y+pt[1].x),0,0,0,0);
	}
protected:
	long m_sx;
	long m_sy;
	long m_radius;
};

class fillcircledata : public drawdata
{
public:
	fillcircledata(long sx,long sy,long radius,BOOL mapmode)
	{
		m_sx = sx;
		m_sy = sy;
		m_radius = radius;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		long mid = m_radius / 2;
		POINT pt[2]   = {{m_sx ,m_sy},{m_radius ,m_radius}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,2);
		}
		Ellipse(dc.m_hDC,(pt[0].x-pt[1].x),(pt[0].y-pt[1].x),(pt[0].x+pt[1].x),(pt[0].y+pt[1].x));
	}
protected:
	long m_sx;
	long m_sy;
	long m_radius;
};

class boxdata : public drawdata
{
public:
	boxdata(long sx,long sy,long ex,long ey,BOOL mapmode)
	{
		m_sx = sx;
		m_sy = sy;
		m_ex = ex;
		m_ey = ey;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[2]   = {{m_sx ,m_sy},{m_ex,m_ey}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,2);
		}
		MoveToEx(dc.m_hDC,pt[0].x,pt[0].y,NULL);
		LineTo  (dc.m_hDC,pt[1].x,pt[0].y);
		LineTo  (dc.m_hDC,pt[1].x,pt[1].y);
		LineTo  (dc.m_hDC,pt[0].x,pt[1].y);
		LineTo  (dc.m_hDC,pt[0].x,pt[0].y);
	}
protected:
	long m_sx;
	long m_sy;
	long m_ex;
	long m_ey;
};

class fillboxdata : public drawdata
{
public:
	fillboxdata(long sx,long sy,long ex,long ey,BOOL mapmode)
	{
		m_sx = sx;
		m_sy = sy;
		m_ex = ex;
		m_ey = ey;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[2]   = {{m_sx ,m_sy},{m_ex,m_ey}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,2);
		}
		Rectangle(dc.m_hDC,pt[0].x,pt[0].y,pt[1].x,pt[1].y);
	}
protected:
	long m_sx;
	long m_sy;
	long m_ex;
	long m_ey;
};

class fillrboxdata : public drawdata
{
public:
	fillrboxdata(long sx,long sy,long ex,long ey,long w,long h,BOOL mapmode)
	{
		m_sx = sx;
		m_sy = sy;
		m_ex = ex;
		m_ey = ey;
		m_w  = w;
		m_h  = h;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[3]   = {{m_sx ,m_sy},{m_ex,m_ey},{m_w,m_h}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,3);
		}
		RoundRect(dc.m_hDC,pt[0].x,pt[0].y,pt[1].x,pt[1].y,pt[2].x,pt[2].y);
	}
protected:
	long m_sx;
	long m_sy;
	long m_ex;
	long m_ey;
	long m_w;
	long m_h;
};

class arcdata : public drawdata
{
public:
	arcdata(long x1,long y1,long x2,long y2,long sx,long sy,long ex,long ey,BOOL mapmode)
	{
		m_x1 = x1;
		m_y1 = y1;
		m_x2 = x2;
		m_y2 = y2;
		m_sx = sx;
		m_sy = sy;
		m_ex = ex;
		m_ey = ey;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[4]   = {{m_x1,m_y1},{m_x2,m_y2},{m_sx ,m_sy},{m_ex,m_ey}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,4);
		}
		Arc(dc.m_hDC,pt[0].x,pt[0].y,pt[1].x,pt[1].y,pt[2].x,pt[2].y,pt[3].x,pt[3].y);
	}
protected:
	long m_x1;
	long m_y1;
	long m_x2;
	long m_y2;
	long m_sx;
	long m_sy;
	long m_ex;
	long m_ey;
};

class fillarcdata : public drawdata
{
public:
	fillarcdata(long x1,long y1,long x2,long y2,long sx,long sy,long ex,long ey,BOOL mapmode)
	{
		m_x1 = x1;
		m_y1 = y1;
		m_x2 = x2;
		m_y2 = y2;
		m_sx = sx;
		m_sy = sy;
		m_ex = ex;
		m_ey = ey;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		POINT pt[4]   = {{m_x1,m_y1},{m_x2,m_y2},{m_sx ,m_sy},{m_ex,m_ey}};
		if(m_bTextMappingMode){
			DPtoLP(dc,pt,4);
		}
		Pie(dc.m_hDC,pt[0].x,pt[0].y,pt[1].x,pt[1].y,pt[2].x,pt[2].y,pt[3].x,pt[3].y);
	}
protected:
	long m_x1;
	long m_y1;
	long m_x2;
	long m_y2;
	long m_sx;
	long m_sy;
	long m_ex;
	long m_ey;
};

class polygondata : public drawdata
{
public:
	polygondata(POINT* pPt,int cnt,BOOL mapmode)
	{
		m_cnt = cnt;
		m_pPt = pPt;
		m_bTextMappingMode = mapmode;
	}
	virtual void Destroy()
	{
		delete[]m_pPt;
		delete this;
	}
	virtual void Draw(CDC dc)
	{
		if(m_bTextMappingMode){
			POINT* pt = new POINT[m_cnt];
			int i;
			for(i=0;i<m_cnt;i++){
				pt[i] = m_pPt[i];
			}
			DPtoLP (dc,pt,m_cnt);
			Polygon(dc.m_hDC,pt,m_cnt);
			delete[]pt;
		}
		else{
			Polygon(dc.m_hDC,m_pPt,m_cnt);
		}
	}
protected:
	POINT* m_pPt;
	int m_cnt;
};

class picturedata : public drawdata
{
public:
	picturedata(IPicture* pPicture,long x,long y,long w,long h,BOOL mapmode)
	{
		m_x = x;
		m_y = y;
		m_h = h;
		m_w = w;
		m_pPicture = pPicture;
		m_bTextMappingMode = mapmode;
		if(m_pPicture){
			m_pPicture->AddRef();
		}
	}
	virtual void Destroy()
	{
		if(m_pPicture){
			m_pPicture->Release();
			m_pPicture = NULL;
		}
	}
	virtual void Draw(CDC dc)
	{
		if(!m_pPicture){
			// rN`[C^[tFCXȂȂ牽Ȃ
			return;
		}
		// IPicture->RenderHIMETRIC̍WKvƂ邪AXN[LOMETRICɂĂ邽߁B
		// iARender̓}csO[hύXȂ̂ŁA^鐔lLOMETRICBj
		OLE_XPOS_HIMETRIC w = 0;
		OLE_XPOS_HIMETRIC h = 0;
		m_pPicture->get_Width(&w);
		m_pPicture->get_Height(&h);

		if(m_bTextMappingMode){
			POINT pt[2] = {{m_x,m_y},{m_x+m_w,m_y+m_h}};
			DPtoLP(dc,pt,2);
			if(m_w < 0){ pt[1].x = w/10; } else { pt[1].x = labs(pt[1].x - pt[0].x); }
			if(m_h < 0){ pt[1].y = h/10; } else { pt[1].y = labs(pt[1].y - pt[0].y); }
			m_pPicture->Render(dc.m_hDC
				,(pt[0].x)
				,(pt[0].y-pt[1].y)
				,(pt[1].x)
				,(pt[1].y)
				,0,0,w,h,NULL);
		}
		else{
			long dw = w / 10;
			long dh = h / 10;
			if(m_w > 0) dw = m_w;
			if(m_h > 0) dh = m_h;
			m_pPicture->Render(dc.m_hDC,m_x,m_y,dw,dh,0,0,w,h,NULL);
		}
	}
protected:
	IPicture* m_pPicture;
	long m_x;
	long m_y;
	long m_h;
	long m_w;
};

/////////////////////////////////////////////////////////////////////////////
// CLayer
class ATL_NO_VTABLE CLayer : 
	public CComObjectRootEx<CComSingleThreadModel>,
//	public CComCoClass<CLayer, &CLSID_Layer>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CLayer>,
	public IDispatchImpl<ILayer, &IID_ILayer, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CLayer()
	{
		// `f[^[ی̃NeBJZbV
		InitializeCriticalSection(&m_objDrawingDataProtection);
		// C[{f[^̏
		m_bVisible = true;
		m_dwColor = 0;
		m_nFontSize = 0;
		m_dwFillColor = 0x808080;
		m_dwFontColor = ::GetSysColor(COLOR_WINDOWTEXT);
		ZeroMemory(m_szFontName,MAX_PATH);
		// }bsO[h
		m_bTextMappingMode = 0;
		m_bFontTextMappingMode = 0;
	}
	void FinalRelease();

//DECLARE_REGISTRY_RESOURCEID(IDR_LAYER)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CLayer)
	COM_INTERFACE_ENTRY(ILayer)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
END_COM_MAP()
BEGIN_CONNECTION_POINT_MAP(CLayer)
END_CONNECTION_POINT_MAP()


// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ILayer
public:
	long GetMappedValue(VARIANT var,long def = 0);
	STDMETHOD(SetMappingMode)(/*[in]*/VARIANT mode);
	STDMETHOD(Picture)(/*[in]*/VARIANT punkVal,/*[in]*/VARIANT x,/*[in]*/VARIANT y,/*[in,optional]*/VARIANT w,/*[in,optional]*/VARIANT h);
	STDMETHOD(Clear)();
	STDMETHOD(FillArc)(/*[in]*/VARIANT x1,/*[in]*/VARIANT y1,/*[in]*/VARIANT x2,/*[in]*/VARIANT y2,/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey);
	STDMETHOD(FillCircle)(/*[in]*/VARIANT x,/*[in]*/VARIANT y,/*[in]*/VARIANT radius);
	STDMETHOD(FillBox)(/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey);
	STDMETHOD(Arc)(/*[in]*/VARIANT x1,/*[in]*/VARIANT y1,/*[in]*/VARIANT x2,/*[in]*/VARIANT y2,/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey);
	STDMETHOD(Box)(/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey);
	STDMETHOD(Line)(/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey);
	STDMETHOD(Circle)(/*[in]*/VARIANT x,/*[in]*/VARIANT y,/*[in]*/VARIANT radius);
	STDMETHOD(Text)(/*[in]*/VARIANT x,/*[in]*/VARIANT y,/*[in]*/VARIANT text);
	STDMETHOD(Polygon)(/*[in]*/VARIANT cx,/*[in]*/VARIANT cy,/*[in]*/VARIANT arrayPt);
	STDMETHOD(FillRBox)(/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey,/*[in]*/VARIANT w,/*[in]*/VARIANT h);
	STDMETHOD(get_FontSize)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_FontSize)(/*[in]*/ short newVal);
	STDMETHOD(get_FillColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FillColor)(/*[in]*/ long newVal);
	STDMETHOD(get_FontName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FontName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Visible)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Visible)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_FontColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontColor)(/*[in]*/ long newVal);
	STDMETHOD(get_Color)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Color)(/*[in]*/ long newVal);
	STDMETHOD(TextBox)(/*[in]*/VARIANT sx,/*[in]*/VARIANT sy,/*[in]*/VARIANT ex,/*[in]*/VARIANT ey,/*[in]*/VARIANT text,/*[in,optional]*/VARIANT fmt);
	void Draw(CDC dc);
	void AddDrawData(drawdata* pDrawData);
protected:
	CRITICAL_SECTION m_objDrawingDataProtection;
	list<drawdata*> m_lstDraw;
	DWORD m_dwFillColor;
	DWORD m_dwFontColor;
	DWORD m_dwColor;
	int m_nFontSize;
	BOOL m_bVisible;
	CHAR m_szFontName[MAX_PATH];
	int m_bTextMappingMode;
	int m_bFontTextMappingMode;
};

#endif //__LAYER_H_
