// Instance.cpp : CInstance ̃Cve[V

#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Instance.h"
#include "profilesection.h"

/////////////////////////////////////////////////////////////////////////////
// CInstance

CInstance::CInstance()
{
	// CEBhE̐
	m_pMainWindow = NULL;
	if(m_pMainWindow->CreateInstance(&m_pMainWindow) == S_OK){
		m_pMainWindow->AddRef();
		// I[o[bvEBhEXgɒǉ
		m_lstOverlappedWnd.push_back(m_pMainWindow);
	}
	// R_CAOC^[tFCX̐
	m_pCommDlg = NULL;
	if(m_pCommDlg->CreateInstance(&m_pCommDlg) == S_OK){
		m_pCommDlg->AddRef();
		// CEBhER_CAOC^[tFCXɐڑ
		if(m_pMainWindow){
			IUnknown* pUnk = NULL;
			if(m_pMainWindow->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
				CComVariant varUnk(pUnk);
				m_pCommDlg->SetMainWindow(varUnk);
			}
		}
	}
	// EFCgJ[\EJEg
	m_dWaitCursor = 0;
}

void CInstance::FinalRelease()
{
	ATLTRACE("CInstance::FinalRelease\r\n");
	// CEBhẺ
	if(m_pMainWindow){
		m_pMainWindow->Release();
		m_pMainWindow = NULL;
	}
	// R_CAOC^[tFCX̉
	if(m_pCommDlg){
		m_pCommDlg->Release();
		m_pCommDlg = NULL;
	}
	// |bvAbvEBhẺ
	list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while(p != m_lstOverlappedWnd.end()){
		(*p)->Close();
		(*p)->Release();
		p = m_lstOverlappedWnd.erase(p);
	}
}

STDMETHODIMP CInstance::get_Dialog(VARIANT *pVal)
{
	// R_CAOC^[tFCXԂ
	::VariantInit(pVal);
	if(m_pCommDlg){
		IUnknown *pUnk = NULL;
		if(m_pCommDlg->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
			pVal->vt      = VT_UNKNOWN;
			pVal->punkVal = pUnk;
		}
	}
	return S_OK;
}

STDMETHODIMP CInstance::CreateFrame(VARIANT *pvarUnk)
{
	::VariantInit(pvarUnk);
	// QƃJEg1ȂEBhE̔js
	list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while(p != m_lstOverlappedWnd.end()){
		if((*p)->m_dwRef == 1){
			// QƃJEg1Ȃ = ̃NXgĂȂ = sv
			BOOL bVisible = false;
			(*p)->get_Visible(&bVisible);
			if(!bVisible){
				// \ĂȂΏĂ悵B
				(*p)->Release();
				p = m_lstOverlappedWnd.erase(p);
				continue;
			}
		}
		p++;
	}
	// EBhE̐
	CComObject<COverlappedWindow>* pNewWnd = NULL;
	if(pNewWnd->CreateInstance(&pNewWnd) == S_OK){
		pNewWnd->AddRef();
		pNewWnd->put_WaitCursor(m_dWaitCursor);
		m_lstOverlappedWnd.push_back(pNewWnd);
		// C^[tFCX̎擾
		IUnknown* pUnk = NULL;
		if(pNewWnd->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
			pvarUnk->vt      = VT_UNKNOWN;
			pvarUnk->punkVal = pUnk;
		}
	}
	return S_OK;
}

STDMETHODIMP CInstance::WaitEvent(VARIANT varTim, VARIANT *pvarUnk)
{
	::VariantInit(pvarUnk);
	// ҋ@Ԃ̎擾
	DWORD sleeptim = 1000;
	CComVariant tim;
	if(tim.ChangeType(VT_I4,&varTim) == S_OK){
		sleeptim = (DWORD)tim.lVal;
	}
	if(sleeptim == 0){
		sleeptim = INFINITE;
	}
	// ׂẴ|bvAbvEBhẼCxgnh擾
	HANDLE hEvent[MAXIMUM_WAIT_OBJECTS] = { NULL };
	HWND   hWnd  [MAXIMUM_WAIT_OBJECTS] = { NULL };
	CComObject<COverlappedWindow>* pOverlapped[MAXIMUM_WAIT_OBJECTS] = { NULL };
	int count = 0;
	int n = 0;
	list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while(p != m_lstOverlappedWnd.end()){
		n = count;
		(*p)->SetWaitParam(&count,hWnd,hEvent);
		for(;n<count;n++){
			pOverlapped[n] = *p;
		}
		p++;
	}
	// bZ[W[v
	if(count > 0){
		DWORD ret = pOverlapped[0]->MessageLoop(sleeptim,count,hWnd,hEvent);
		if(ret > 0 && ret <= (DWORD)count){
			if(pOverlapped[ret-1]){
				// OVERLAPPEDWINDOWIuWFNgւ̃C^[tFCXԂ
				IUnknown* pUnk = NULL;
				if(pOverlapped[ret - 1]->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
					pvarUnk->vt      = VT_UNKNOWN;
					pvarUnk->punkVal = pUnk;
				}
			}
		}
	}
	return S_OK;
}

STDMETHODIMP CInstance::get_MainFrame(VARIANT *pVal)
{
	::VariantInit(pVal);
	if(m_pMainWindow){
		IUnknown* pUnk = NULL;
		if(m_pMainWindow->QueryInterface(IID_IUnknown,(void**)&pUnk) == S_OK){
			pVal->vt      = VT_UNKNOWN;
			pVal->punkVal = pUnk;
		}
	}
	return S_OK;
}

STDMETHODIMP CInstance::get_WaitCursor(short *pVal)
{
	*pVal = m_dWaitCursor;
	return S_OK;
}

STDMETHODIMP CInstance::put_WaitCursor(short newVal)
{
	m_dWaitCursor = newVal;
	// ׂẴ|bvAbvEBhEɃEFCgJ[\lݒ肷
	list<CComObject<COverlappedWindow>*>::iterator p = m_lstOverlappedWnd.begin();
	while(p != m_lstOverlappedWnd.end()){
		(*p)->put_WaitCursor(newVal);
		p++;
	}
	return S_OK;
}

STDMETHODIMP CInstance::get_Keyboard(VARIANT vk, BOOL *pVal)
{
	CComVariant varVk;
	if(varVk.ChangeType(VT_I2,&vk) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	*pVal = (GetAsyncKeyState(varVk.iVal) & 0x8000)?VB_TRUE:VB_FALSE;
	return S_OK;
}

STDMETHODIMP CInstance::get_MousePosX(short *pVal)
{
	POINT pt;
	::GetCursorPos(&pt);
	*pVal = (short)pt.x; //UNDONE: xĂB
	return S_OK;
}

STDMETHODIMP CInstance::get_MousePosY(short *pVal)
{
	POINT pt;
	::GetCursorPos(&pt);
	*pVal = (short)pt.y; //UNDONE: xĂB
	return S_OK;
}

STDMETHODIMP CInstance::get_Version(double *pVal)
{
	*pVal = 0.91;
	return S_OK;
}
