// CCommDialog.cpp : CCCommDialog ̃Cve[V

#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "CommDialog.h"
#include "generic.h"
#include "ObjectVector.h"

/////////////////////////////////////////////////////////////////////////////
// CCommDialog

void CCommDialog::CommFileDialog(VARIANT* pvarReturn,VARIANT varPathName, VARIANT varFilter,BOOL bMode,DWORD flag)
{
	::VariantInit(pvarReturn);

	// t@CJEۑ_CAOʃ[`
	CComVariant path;
	CComVariant filter;
	const int PATHBUFMAX = 8192;
	CHAR szPathName[PATHBUFMAX] = {0};
	CHAR szFilter  [MAX_PATH+2] = {0};
	CHAR szDefExtention[MAX_PATH] = {0};
	CHAR szInitialDir[MAX_PATH] = {0};

	if(path.ChangeType(VT_BSTR,&varPathName) == S_OK){
		// t@C̎o
		WideCharToMultiByte(GetACP(),0,path.bstrVal,-1,szPathName,PATHBUFMAX,NULL,NULL);
	}
	if(filter.ChangeType(VT_BSTR,&varFilter) == S_OK){
		// tB^w肪
		WideCharToMultiByte(GetACP(),0,filter.bstrVal,-1,szFilter,MAX_PATH,NULL,NULL);
		LPSTR p = szFilter;
		LPSTR pExt = NULL;
		while(*p){
			if(*p == '|'){
				*p++ = 0;
				if(!pExt){
					// ŏ̋؂}[Nŏ̊gq}[Nł낤B
					pExt = p;
				}
			}
			p = CharNextA(p);
		}
		// gqtB^ł΍ŏ̊gq̂ݎo
		lstrcpyA(szDefExtention,pExt);
		pExt = szDefExtention;
		while(*pExt){
			if(*pExt == ';'){
				break;
			}
			pExt = CharNextA(pExt);
		}
	}

	OPENFILENAME ofn = {0};
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.lpstrFilter = szFilter;
	ofn.lpstrFile   = szPathName;
	ofn.nMaxFile    = PATHBUFMAX;
	ofn.lpstrDefExt = szDefExtention;
	ofn.Flags       = flag;
	ofn.hwndOwner   = GetMainWindow();

	if(m_bstr_InitialDir.length() > 0){
		// fBNg
		WideCharToMultiByte(GetACP(),0,m_bstr_InitialDir,-1,szInitialDir,MAX_PATH,NULL,NULL);
		ofn.lpstrInitialDir = szInitialDir;
	}

	if(m_bNoDereferenceLinks){
		// V[gJbgÂ܂܎B
		ofn.Flags |= OFN_NODEREFERENCELINKS;
	}

	TCHAR szCaption[MAX_PATH] = {0};
	BOOL result = false;
	if(bMode){
		// J_CAO
		ofn.Flags |= (m_bReadonly)?OFN_READONLY:0;
		if(m_bstr_OpenFileCaption.length() > 0){
			WideCharToMultiByte(GetACP(),0,m_bstr_OpenFileCaption,-1,szCaption,MAX_PATH,NULL,NULL);
			ofn.lpstrTitle = szCaption;
		}
		result = GetOpenFileName(&ofn);
		if(result){
			m_bReadonly = (ofn.Flags & OFN_READONLY)?true:false;
		}
	}
	else{
		// ۑ_CAO
		if(m_bstr_SaveFileCaption.length() > 0){
			WideCharToMultiByte(GetACP(),0,m_bstr_SaveFileCaption,-1,szCaption,MAX_PATH,NULL,NULL);
			ofn.lpstrTitle = szCaption;
		}
		result = GetSaveFileName(&ofn);
	}

	if(result){
		if(!(ofn.Flags & OFN_ALLOWMULTISELECT)){
			// Pt@CI
			CComVariant retpath;
			retpath = (LPCSTR)ofn.lpstrFile;
			retpath.Detach(pvarReturn);
		}
		else{
			// t@CI
			// Ԃꂽt@Cv
			int cnt = 0;
			LPCSTR p = szPathName;
			while(*p){
				cnt++;
				while(*p++);
			}
			// VO܂̓}`
			SAFEARRAY *pArray = NULL;
			if(cnt == 1){
				// 1ȂtpXԂĂ
				CComVariant tmp((LPCSTR)szPathName);
				pArray = SafeArrayCreateVector(VT_VARIANT,0,1);
				long indx = 0;
				SafeArrayPutElement(pArray,&indx,&tmp);
			}
			else if(cnt > 1){
				// SAFEARRAY̍쐬
				pArray = SafeArrayCreateVector(VT_VARIANT,0,cnt-1);
				// ȂŏfBNgA2Ԗڈȍ~t@C
				p = szPathName;
				_bstr_t dirname = (LPCSTR)p;
				// tH_vCXIĂȂΒǉ
				LPCWSTR wp = dirname;
				while(*wp)wp++;
				if(wp - 1 > (LPCWSTR)dirname && *(wp - 1) != '\\'){
					dirname += L"\\";
				}
				while(*p++);
				// 2Ԗڈȍ~̎擾
				long indx = 0;
				while(*p){
					_bstr_t name = (LPCSTR)p;
					_bstr_t path = dirname + name;
					CComVariant tmp((BSTR)path);
					SafeArrayPutElement(pArray,&indx,&tmp);
					while(*p++);
					indx++;
				}
			}
			// SAFEARRAY쐬Ă
			if(pArray){
				pvarReturn->vt     = VT_ARRAY | VT_VARIANT;
				pvarReturn->parray = pArray;
			}
		}// Single or Multi
	}// if result is ok
}

/////////////////////////////////
// C^[tFCX

STDMETHODIMP CCommDialog::OpenFileDialog(VARIANT varPathName,VARIANT varFilter,VARIANT* pvarReturn)
{
	DWORD flags =	(m_bEnableCreatePrompt ? OFN_CREATEPROMPT : OFN_FILEMUSTEXIST)
				  +	(m_bEnableReadonly     ? 0                : OFN_HIDEREADONLY );
	CommFileDialog(pvarReturn,varPathName,varFilter,true,flags|OFN_ENABLESIZING);
	return S_OK;
}

STDMETHODIMP CCommDialog::SaveFileDialog(VARIANT varPathName, VARIANT varFilter, VARIANT* pvarReturn)
{
	CommFileDialog(pvarReturn,varPathName,varFilter,false,OFN_ENABLESIZING|OFN_OVERWRITEPROMPT);
	return S_OK;
}


STDMETHODIMP CCommDialog::MultiOpenFileDialog(VARIANT varMulti,VARIANT varFilter,VARIANT* pvarReturn)
{
	DWORD flags =	(m_bEnableCreatePrompt ? OFN_CREATEPROMPT : OFN_FILEMUSTEXIST)
				  +	(m_bEnableReadonly     ? 0                : OFN_HIDEREADONLY );
	CommFileDialog(pvarReturn,varMulti,varFilter,true,flags|OFN_ALLOWMULTISELECT|OFN_EXPLORER|OFN_ENABLESIZING);
	return S_OK;
}

STDMETHODIMP CCommDialog::get_OpenFileCaption(BSTR *pVal)
{
	*pVal = m_bstr_OpenFileCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_OpenFileCaption(BSTR newVal)
{
	m_bstr_OpenFileCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_SaveFileCaption(BSTR *pVal)
{
	*pVal = m_bstr_SaveFileCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_SaveFileCaption(BSTR newVal)
{
	m_bstr_SaveFileCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_EnableCreatePrompt(BOOL *pVal)
{
	*pVal = m_bEnableCreatePrompt?VB_TRUE:VB_FALSE;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_EnableCreatePrompt(BOOL newVal)
{
	m_bEnableCreatePrompt = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_EnableReadOnly(BOOL *pVal)
{
	*pVal = m_bEnableReadonly?VB_TRUE:VB_FALSE;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_EnableReadOnly(BOOL newVal)
{
	m_bEnableReadonly = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_ReadOnly(BOOL *pVal)
{
	*pVal = m_bReadonly?VB_TRUE:VB_FALSE;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_ReadOnly(BOOL newVal)
{
	m_bReadonly = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_NoDereferenceLinks(BOOL *pVal)
{
	*pVal = m_bNoDereferenceLinks;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_NoDereferenceLinks(BOOL newVal)
{
	m_bNoDereferenceLinks = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_InitialDir(BSTR *pVal)
{
	*pVal = m_bstr_InitialDir.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_InitialDir(BSTR newVal)
{
	m_bstr_InitialDir = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::get_HWND(long *pVal)
{
	*pVal = (long)m_hStaticMainWindow;
	return S_OK;
}

STDMETHODIMP CCommDialog::put_HWND(long newVal)
{
	m_hStaticMainWindow = (HWND)newVal;
	if(m_pMainWindow){
		m_pMainWindow->Release();
		m_pMainWindow = NULL;
	}
	return S_OK;
}

STDMETHODIMP CCommDialog::get_BrowseForFolderCaption(BSTR *pVal)
{
	*pVal = m_bstr_BrowseForFolderCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_BrowseForFolderCaption(BSTR newVal)
{
	m_bstr_BrowseForFolderCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::BrowseForFolder(VARIANT varCaption,VARIANT varDir, VARIANT varMode,VARIANT* pvarReturn)
{
	::VariantInit(pvarReturn);
	// LvV̐ݒ
	CComVariant caption;
	if(varCaption.vt != VT_ERROR && varCaption.vt != VT_NULL && varCaption.vt != VT_EMPTY &&
		caption.ChangeType(VT_BSTR,&varCaption) == S_OK){
		put_BrowseForFolderCaption(caption.bstrVal);
	}

	TCHAR szDirName[MAX_PATH];
	TCHAR szTitle[MAX_PATH];
	BROWSEINFO binfo = {0};
	binfo.hwndOwner = GetMainWindow();
	if(m_bstr_BrowseForFolderCaption.length() > 0){
		WideCharToMultiByte(GetACP(),0,m_bstr_BrowseForFolderCaption,-1,szTitle,MAX_PATH,NULL,NULL);
		binfo.lpszTitle = szTitle;
	}
	CComVariant path;
	if(path.ChangeType(VT_BSTR,&varDir) == S_OK){
		// t@C̎o
		WideCharToMultiByte(GetACP(),0,path.bstrVal,-1,szDirName,MAX_PATH,NULL,NULL);
	}
	binfo.pszDisplayName = szDirName;
	int mode = 0;
	CComVariant varTmp;
	if(varTmp.ChangeType(VT_I4,&varMode) == S_OK){
		mode = varTmp.lVal;
	}
	binfo.ulFlags = 0;//BIF_NEWDIALOGSTYLE; // BIF_USENEWUI
	switch(mode & 0x0f)
	{
	case 0:
	default:
		binfo.ulFlags |= BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;
		binfo.lpfn           = BrowseCallbackProc;
		binfo.lParam         = (LPARAM)szDirName;
		break;
	case 1:
		binfo.ulFlags |= BIF_BROWSEFORCOMPUTER;
		break;
	case 2:
		binfo.ulFlags |= BIF_BROWSEFORPRINTER;
		break;
	case 3:
		binfo.ulFlags |= BIF_RETURNFSANCESTORS;
		break;
	}
	if(mode & 0x10){
		binfo.ulFlags |= BIF_BROWSEINCLUDEFILES;
	}
	if(mode & 0x20){
		binfo.ulFlags |= BIF_BROWSEINCLUDEURLS;
	}
	if(mode & 0x40){
		binfo.ulFlags |= BIF_DONTGOBELOWDOMAIN;
	}

	LPITEMIDLIST idlst = NULL;
	if((idlst = SHBrowseForFolder(&binfo)) != NULL){
		IMalloc *pMalloc;
		SHGetMalloc(&pMalloc);
		SHGetPathFromIDList(idlst,szDirName);
		pMalloc->Free(idlst);
		pMalloc->Release();
		CComVariant tmp((LPCSTR)szDirName);
		tmp.Detach(pvarReturn);
	}
	return S_OK;
}


int CALLBACK CCommDialog::BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	switch(uMsg)
	{
	case BFFM_INITIALIZED:
		SendMessage(hwnd,BFFM_SETSELECTION,true,lpData);
		break;
	case BFFM_SELCHANGED:
		{
			TCHAR szBuf[MAX_PATH];
			BOOL bResult = SHGetPathFromIDList((LPITEMIDLIST)lParam,szBuf);
			SendMessage(hwnd,BFFM_ENABLEOK,0,bResult);
		}
		break;
	case BFFM_VALIDATEFAILED:
		break;
	}
	return 0;
}

HWND CCommDialog::GetMainWindow()
{
	HWND hWnd = m_hStaticMainWindow;
	if(m_pMainWindow){
		m_pMainWindow->get_HWND((long*)&hWnd);
	}
	return hWnd;
}

STDMETHODIMP CCommDialog::SetMainWindow(VARIANT varUnk)
{
	// ̃C^[tFCX̉
	if(m_pMainWindow){
		m_pMainWindow->Release();
		m_pMainWindow = NULL;
	}
	// C^[tFCX̎擾
	CComVariant tmp;
	if(tmp.ChangeType(VT_UNKNOWN,&varUnk) == S_OK){
		if(tmp.punkVal->QueryInterface(IID_IOverlappedWindow,(void**)&m_pMainWindow) == S_OK){
			return S_OK;
		}
	}
	return DISP_E_UNKNOWNINTERFACE;
}

STDMETHODIMP CCommDialog::MessageBox(VARIANT mes, VARIANT typ, VARIANT icon, VARIANT* pRet)
{
	CComVariant ret;
	LPSTR pBuf = NULL;
	CComVariant varMes;
	if(varMes.ChangeType(VT_BSTR,&mes) == S_OK){
		int sz = WideCharToMultiByte(GetACP(),0,varMes.bstrVal,-1,NULL,0,NULL,NULL);
		pBuf = new CHAR[sz+1];
		WideCharToMultiByte(GetACP(),0,varMes.bstrVal,-1,pBuf,sz,NULL,NULL);
		pBuf[sz] = 0;
	}
	UINT mode = MB_OK;
	CComVariant varType,varIcon;
	if(varType.ChangeType(VT_I2,&typ) == S_OK){
		if(varType.iVal / 10){
			mode = MB_DEFBUTTON2;
		}
		switch(varType.iVal % 10)
		{
		case 0:
		default:
			mode |= MB_OK;
			break;
		case 1:
			mode |= MB_OKCANCEL;
			break;
		case 2:
			mode |= MB_YESNO;
			break;
		case 3:
			mode |= MB_YESNOCANCEL;
			break;
		case 4:
			mode |= MB_RETRYCANCEL;
			break;
		case 5:
			mode |= MB_ABORTRETRYIGNORE;
			break;
		}
	}
	if(varIcon.ChangeType(VT_I2,&icon) == S_OK){
		switch(varIcon.iVal)
		{
		case 0:
		default:
			break;
		case 1:
			mode |= MB_ICONERROR;
			break;
		case 2:
			mode |= MB_ICONWARNING;
			break;
		case 3:
			mode |= MB_ICONINFORMATION;
			break;
		case 4:
			mode |= MB_ICONQUESTION;
			break;
		}
	}
	int md = ::MessageBox(GetMainWindow(),pBuf,GetMainCaption(),mode);
	switch(md)
	{
	case IDOK:
	case IDYES:
	case IDRETRY:
		ret = (short)1;
		break;
	case IDCANCEL:
	case IDABORT:
		ret = (short)-1;
		break;
	case IDNO:
	case IDIGNORE:
		ret = (short)0;
		break;
	}
	*pRet = ret;
	return S_OK;
}

LPCSTR CCommDialog::GetMainCaption()
{
	static CHAR szCaption[MAX_PATH];
	if(!m_bstr_MessageCaption.length() && m_pMainWindow){
		// LvVw肳ĂȂȂ擾
		BSTR bstrCaption;
		m_pMainWindow->get_Caption(&bstrCaption);
		int cnt = WideCharToMultiByte(GetACP(),0,bstrCaption,-1,szCaption,MAX_PATH,NULL,NULL);
		szCaption[cnt] = 0;
		SysFreeString(bstrCaption);
	}
	else{
		int cnt = WideCharToMultiByte(GetACP(),0,m_bstr_MessageCaption,-1,szCaption,MAX_PATH,NULL,NULL);
		szCaption[cnt] = 0;
	}
	return szCaption;
}

STDMETHODIMP CCommDialog::get_MessageCaption(BSTR *pVal)
{
	*pVal = m_bstr_MessageCaption.copy();
	return S_OK;
}

STDMETHODIMP CCommDialog::put_MessageCaption(BSTR newVal)
{
	m_bstr_MessageCaption = newVal;
	return S_OK;
}

STDMETHODIMP CCommDialog::ColorDialog(VARIANT *pcolorVal)
{
	::VariantInit(pcolorVal);
	m_color.hwndOwner = GetMainWindow();
	if(ChooseColor(&m_color)){
		pcolorVal->vt   = VT_I4;
		pcolorVal->lVal = (long)m_color.rgbResult;
	}
	return S_OK;
}
