// Form.cpp : CForm ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Form.h"

/////////////////////////////////////////////////////////////////////////////
// CForm

void CForm::FinalRelease()
{
	ATLTRACE("CForm::FinalRelease\r\n");
	// 
	ClearControls();
	// Rg[wiuV̔j
	if (m_hBrushControlBkColor) {
		DeleteObject(m_hBrushControlBkColor);
		m_hBrushControlBkColor = NULL;
	}
	// tHg̔j
	if (m_hControlFont) {
		DeleteObject(m_hControlFont);
		m_hControlFont = NULL;
	}
}

STDMETHODIMP CForm::get_Control(VARIANT varNum, VARIANT *pVal)
{
	::VariantInit(pVal);
	CComVariant tmp;
	int nID = -1;
	if (tmp.ChangeType(VT_I2, &varNum) == S_OK) {
		nID = tmp.iVal;
	}
	if (nID > 0) {
		std::list<CComObject<CControl>*>::iterator p = m_lstControl.begin();
		while (p != m_lstControl.end()) {
			if ((*p)->GetID() == nID) {
				// ID𔭌̂ŁAԂ
				IUnknown* pUnk = NULL;
				if ((*p)->QueryInterface(IID_IUnknown, (void**)&pUnk) == S_OK) {
					pVal->vt = VT_UNKNOWN;
					pVal->punkVal = pUnk;
				}
				break;
			}
			p++;
		}
	}
	return S_OK;
}

STDMETHODIMP CForm::SetControlFont(VARIANT fontname, VARIANT fontsize)
{
	CComVariant varName;
	ATL::CString szFontName;
	if (varName.ChangeType(VT_BSTR, &fontname) == S_OK) {
		szFontName = varName.bstrVal;
	}

	CComVariant varSize;
	int siz = 20;
	if (varSize.ChangeType(VT_I2, &fontsize) == S_OK) {
		siz = varSize.iVal;
	}

	// mۍς݃tHg
	if (m_hControlFont) {
		DeleteObject(m_hControlFont);
	}

	// VtHg쐬
	m_hControlFont = CreateFont(
		siz,
		0, 0, 0, 0, false, false, false,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY,
		FF_DONTCARE,
		szFontName);

	m_nControlFontSize = siz;

	// ݂̃Rg[ׂĂɓKp(Ă)
	std::list<CComObject<CControl>*>::iterator p = m_lstControl.begin();
	while (p != m_lstControl.end()) {
		(*p)->SetFont(m_hControlFont);
		p++;
	}
	return S_OK;
}

STDMETHODIMP CForm::Label(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, SS_NOTIFY, 0, _TEXT("STATIC"));
	return S_OK;
}

STDMETHODIMP CForm::Button(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, WS_TABSTOP | BS_PUSHBUTTON, 0, _TEXT("BUTTON"));
	return S_OK;
}

STDMETHODIMP CForm::CheckBox(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, WS_TABSTOP | BS_AUTOCHECKBOX, 0, _TEXT("BUTTON"));
	return S_OK;
}

STDMETHODIMP CForm::RadioButton(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, BS_AUTORADIOBUTTON | (m_bControlNextIsGroupHead ? WS_TABSTOP : 0), 0, _TEXT("BUTTON"));
	return S_OK;
}

STDMETHODIMP CForm::CheckBox3state(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, WS_TABSTOP | BS_AUTO3STATE, 0, _TEXT("BUTTON"));
	return S_OK;
}

STDMETHODIMP CForm::PushCheckButton(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, WS_TABSTOP | BS_AUTOCHECKBOX | BS_PUSHLIKE, 0, _TEXT("BUTTON"));
	return S_OK;
}

STDMETHODIMP CForm::PushRadioButton(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, 0, BS_AUTORADIOBUTTON | BS_PUSHLIKE | (m_bControlNextIsGroupHead ? WS_TABSTOP : 0), 0, _TEXT("BUTTON"));
	return S_OK;
}

STDMETHODIMP CForm::ReadonlyEdit(VARIANT text, VARIANT width, VARIANT height, VARIANT *punkVal)
{
	DWORD style = WS_TABSTOP | ES_READONLY;
	if (height.vt != VT_ERROR && height.vt != VT_NULL && height.vt != VT_EMPTY) {
		// w肪ꍇ͕s
		style |= ES_MULTILINE | ES_AUTOVSCROLL | WS_VSCROLL;
	}
	else {
		// Ps
		style |= ES_AUTOHSCROLL;
	}
	CreateControlCore(text, width, height, punkVal, m_bControlUseStaticEdge ? WS_EX_STATICEDGE : WS_EX_CLIENTEDGE, style, 0, _TEXT("EDIT"));
	return S_OK;
}

STDMETHODIMP CForm::Edit(VARIANT text, VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	DWORD style = WS_TABSTOP;
	if (height.vt != VT_ERROR && height.vt != VT_NULL && height.vt != VT_EMPTY) {
		// w肪ꍇ͕s
		style |= ES_MULTILINE | WS_VSCROLL | ES_WANTRETURN;
	}
	else {
		// Ps
		style |= ES_AUTOHSCROLL;
	}
	CreateControlCore(text, width, height, pvarUnk, WS_EX_CLIENTEDGE, style, 0, _TEXT("EDIT"));
	return S_OK;
}

STDMETHODIMP CForm::PasswordEdit(VARIANT text, VARIANT width, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(text, width, dmy, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | ES_PASSWORD, 0, _TEXT("EDIT"));
	return S_OK;
}

STDMETHODIMP CForm::ListBox(VARIANT width, VARIANT height, VARIANT* pvarUnk)
{
	CComVariant text;
	CreateControlCore(text, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | LBS_NOTIFY | LBS_USETABSTOPS | LBS_NOINTEGRALHEIGHT | LBS_DISABLENOSCROLL, 0, _TEXT("LISTBOX"));
	return S_OK;
}

STDMETHODIMP CForm::MultiListBox(VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CComVariant text;
	CreateControlCore(text, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | LBS_NOTIFY | LBS_USETABSTOPS | LBS_NOINTEGRALHEIGHT | LBS_MULTIPLESEL |/*LBS_EXTENDEDSEL|*/LBS_DISABLENOSCROLL | LBS_HASSTRINGS, 0, _TEXT("LISTBOX"));
	return S_OK;
}

STDMETHODIMP CForm::DropdownList(VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(dmy, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | CBS_DROPDOWNLIST | CBS_SORT, 0, _TEXT("COMBOBOX"));
	return S_OK;
}

STDMETHODIMP CForm::DropdownEdit(VARIANT text, VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CreateControlCore(text, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | CBS_DROPDOWN | CBS_AUTOHSCROLL | CBS_SORT, 0, _TEXT("COMBOBOX"));
	return S_OK;
}

STDMETHODIMP CForm::TreeView(VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(dmy, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | TVS_DISABLEDRAGDROP | TVS_HASBUTTONS | TVS_HASLINES | TVS_LINESATROOT | TVS_SHOWSELALWAYS, 0, WC_TREEVIEW);
	return S_OK;
}

STDMETHODIMP CForm::ListView(VARIANT colum, VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(colum, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | LVS_REPORT | LVS_SHOWSELALWAYS, 0, WC_LISTVIEW);
	return S_OK;
}

STDMETHODIMP CForm::EditListView(VARIANT colum, VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(colum, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | LVS_REPORT | LVS_EDITLABELS | LVS_SHOWSELALWAYS, 0, WC_LISTVIEW);
	return S_OK;
}

STDMETHODIMP CForm::CheckListView(VARIANT colum, VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CComVariant dmy;
	CreateControlCore(colum, width, height, pvarUnk, WS_EX_CLIENTEDGE, WS_TABSTOP | LVS_SINGLESEL | LVS_REPORT, LVS_EX_CHECKBOXES | LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT, WC_LISTVIEW);
	return S_OK;
}

STDMETHODIMP CForm::ClearControls()
{
	// Rg[ׂĔj
	std::list<CComObject<CControl>*>::iterator p = m_lstControl.begin();
	while (p != m_lstControl.end()) {
		(*p)->Destroy(); // EBhEjQƂcĂANZXsɂ
		(*p)->Release();
		p = m_lstControl.erase(p);
	}
	m_nControlNextY = 0;
	m_nControlNextY0 = 0;
	m_nCommandID = 10;
	m_nControlLeftMargin = 5;
	m_nControlRightMargin = 5;
	m_nControlNextX = m_nControlLeftMargin;
	m_bControlNextIsGroupHead = false;
	m_bControlUseStaticEdge = true;
	//
	// Rg[ptHg̍쐬
	if (m_hControlFont) {
		DeleteObject(m_hControlFont);
	}
	m_nControlFontSize = 16;
	m_hControlFont = CreateFont(m_nControlFontSize, 0, 0, 0, 0, false, false, false, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_DONTCARE, NULL);
	return S_OK;
}

CControl* CForm::CreateControlCore(VARIANT &text, VARIANT &width, VARIANT &height, VARIANT *pvarUnk, DWORD extstyle, DWORD style, DWORD afterstyle, LPCTSTR classname)
{
	CComVariant varText;
	ATL::CString szCaption;
	if (varText.ChangeType(VT_BSTR, &text) == S_OK) {
		szCaption = varText.bstrVal;
	}

	// zuTCY̎擾
	int nWidth = (m_nWindowWidth - m_nControlRightMargin) - m_nControlNextX;
	if (nWidth <= 0) {
		ControlBreak();
		nWidth = (m_nWindowWidth - m_nControlRightMargin) - m_nControlNextX;
	}
	CComVariant varWidth;
	if (varWidth.ChangeType(VT_I2, &width) == S_OK) {
		nWidth = varWidth.iVal * m_nControlFontSize;
		if (nWidth + m_nControlNextX > m_nWindowWidth) {
			ControlBreak();
		}
	}

	int nHeight = m_nControlFontSize;
	CComVariant varHeight;
	if ((height.vt != VT_EMPTY && height.vt != VT_ERROR && height.vt != VT_NULL)
		&& varHeight.ChangeType(VT_I2, &height) == S_OK) {
		nHeight = varHeight.iVal * m_nControlFontSize;
	}

	// O[vwb_
	if (m_bControlNextIsGroupHead) {
		style |= WS_GROUP;
		m_bControlNextIsGroupHead = false;
	}

	// CX^X̐
	CComObject<CControl>* pControl = NULL;
	HRESULT hRet = CComObject<CControl>::CreateInstance(&pControl);
	// FIXME: G[Ԃ悤ɂׂ
	ATLASSERT(SUCCEEDED(hRet));

	// QƃJEgA|C^̕ۑ
	pControl->AddRef();
	pControl->SetParam(afterstyle, extstyle, classname, szCaption, style, m_nControlNextX, m_nControlNextY, nWidth, nHeight + 6, m_nCommandID);
	// Xgɓo^
	m_lstControl.push_back(pControl);

	// EBhEς݂ł΁Aɐs
	// łȂ΃EBhEɎ擾
	if (m_hOwner) {
		pControl->Create(m_hOwner);
		pControl->SetFont(m_hControlFont);
		pControl->SetColor(m_dwControlColor);
	}

	// ̃C^[tFCX߂lƂ
	IUnknown* pUnk = NULL;
	hRet = pControl->QueryInterface(IID_IUnknown, (void**)&pUnk);
	ATLASSERT(SUCCEEDED(hRet));
	::VariantInit(pvarUnk);
	pvarUnk->vt = VT_UNKNOWN;
	pvarUnk->punkVal = pUnk;

	// ɉsƂɈړ
	if (!lstrcmp(classname, _TEXT("COMBOBOX"))) {
		// R{{bNX͕\Ă̂1sB
		nHeight = m_nControlFontSize;
	}
	int ny = m_nControlNextY + nHeight + 7;
	if (m_nControlNextY0 < ny) {
		m_nControlNextY0 = ny;
	}
	// ։s
	m_nControlNextX += nWidth + 2;
	if (m_nControlNextX >= m_nWindowWidth) {
		// I[o[܂ԂB
		ControlBreak();
	}
	m_nCommandID++;
	return pControl;
}

STDMETHODIMP CForm::get_LeftMargin(short *pVal)
{
	*pVal = m_nControlLeftMargin;
	return S_OK;
}

STDMETHODIMP CForm::put_LeftMargin(short newVal)
{
	m_nControlLeftMargin = newVal;
	return S_OK;
}

STDMETHODIMP CForm::ControlBreak()
{
	m_nControlNextX = m_nControlLeftMargin;
	m_nControlNextY = m_nControlNextY0;
	return S_OK;
}

STDMETHODIMP CForm::ControlGroup()
{
	m_bControlNextIsGroupHead = true;
	return S_OK;
}

STDMETHODIMP CForm::ControlPad(VARIANT width, VARIANT height)
{
	// 󔒂
	CComVariant varWidth, varHeight;
	if (varHeight.ChangeType(VT_I2, &height) == S_OK) {
		ControlBreak();
		m_nControlNextY += varHeight.iVal;
	}
	if (varWidth.ChangeType(VT_I2, &width) == S_OK) {
		m_nControlNextX += varWidth.iVal;
	}
	return S_OK;
}


STDMETHODIMP CForm::StatusLabel(VARIANT text, VARIANT width, VARIANT height, VARIANT *pvarUnk)
{
	CreateControlCore(text, width, height, pvarUnk, m_bControlUseStaticEdge ? WS_EX_STATICEDGE : WS_EX_CLIENTEDGE, SS_NOTIFY, 0, _TEXT("STATIC"));
	return S_OK;
}

STDMETHODIMP CForm::ControlUseStaticEdge(VARIANT mode)
{
	int nMode = true;
	CComVariant varMode;
	if ((mode.vt != VT_EMPTY && mode.vt != VT_ERROR && mode.vt != VT_NULL)
		&& (varMode.ChangeType(VT_I2, &mode) == S_OK)) {
		nMode = varMode.iVal;
	}
	m_bControlUseStaticEdge = nMode;
	return S_OK;
}

void CForm::AttachOwner(HWND hOwner)
{
	m_hOwner = hOwner;
	// O쐬ĂRg[ׂĐ
	std::list<CComObject<CControl>*>::iterator p = m_lstControl.begin();
	while (p != m_lstControl.end()) {
		(*p)->Create(hOwner);
		(*p)->SetFont(m_hControlFont);
		(*p)->SetColor(m_dwControlColor);
		p++;
	}
}

void CForm::DetachOwner()
{
	// ׂẴRg[j
	ClearControls();
	// I[i[𖳌ɂ
	m_hOwner = NULL;
}

void CForm::SetWindowSize(int width, int height, DWORD style, DWORD styleEx)
{
	// EBhẼTCYw肷
	// AIɍE̘g

	//  Windows̘g̎Z@ύX.(2015/08)
	// NCAg肵ăEBhE߂ƁA
	// ̍ۂ̘g߂B
	RECT rct = {0, 0, width, height};
	AdjustWindowRectEx(&rct, style, false, styleEx);

	int diff_w = rct.right - width;
	int diff_h = rct.bottom - height;

	m_nWindowWidth = width - diff_w * 2;
	m_nWindowHeight = height - diff_h * 2;
}

STDMETHODIMP CForm::get_RightMargin(short *pVal)
{
	*pVal = m_nControlRightMargin;
	return S_OK;
}

STDMETHODIMP CForm::put_RightMargin(short newVal)
{
	m_nControlRightMargin = newVal;
	return S_OK;
}

void CForm::EnableAllControl(BOOL mode)
{
	// SRg[̃Cl[uEfBZ[u̐ؑ
	if (!::IsWindow(m_hOwner)) {
		// CEBhE쐬ĂȂΉȂ
		return;
	}
	std::list<CComObject<CControl>*>::iterator p = m_lstControl.begin();
	while (p != m_lstControl.end()) {
		(*p)->put_Enable(mode);
		p++;
	}
}

STDMETHODIMP CForm::get_ControlColor(long *pVal)
{
	*pVal = (long)m_dwControlColor;
	return S_OK;
}

STDMETHODIMP CForm::put_ControlColor(long newVal)
{
	if (m_hBrushControlBkColor) {
		DeleteObject(m_hBrushControlBkColor);
	}
	m_hBrushControlBkColor = CreateSolidBrush(m_dwControlColor);
	m_dwControlColor = newVal;
	return S_OK;
}

DWORD CForm::GetControlColor()
{
	return m_dwControlColor;
}

HBRUSH CForm::GetControlColorBrush()
{
	return m_hBrushControlBkColor;
}

BOOL CForm::FindControlEventName(int eventcode, BSTR *pEventName)
{
	// pEventName͏ĂȂBSTRւ̃|C^n
	// ĂяotrueAABSTRKv
	std::list<CComObject<CControl>*>::iterator p = m_lstControl.begin();
	while (p != m_lstControl.end()) {
		if ((*p)->GetID() == eventcode) {
			(*p)->GetClassEvent(pEventName);
			return true;
		}
		p++;
	}
	return false;
}

HWND CForm::GetAttachedOwner()
{
	return m_hOwner;
}
