
// CommDialog.h : Declaration of the CCommDialog

#pragma once

#include "resource.h"       // C V{
#include <atlctl.h>
#include "SeraphyScriptToolsCP.h"

/////////////////////////////////////////////////////////////////////////////
// CCommDialog
class ATL_NO_VTABLE CCommDialog :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CStockPropImpl<CCommDialog, ICommDialog, &IID_ICommDialog, &LIBID_SERAPHYSCRIPTTOOLSLib>,
	public CComControl<CCommDialog>,
	public IPersistStreamInitImpl<CCommDialog>,
	public IOleControlImpl<CCommDialog>,
	public IOleObjectImpl<CCommDialog>,
	public IOleInPlaceActiveObjectImpl<CCommDialog>,
	public IViewObjectExImpl<CCommDialog>,
	public IOleInPlaceObjectWindowlessImpl<CCommDialog>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CCommDialog>,
	public IPersistStorageImpl<CCommDialog>,
	public ISpecifyPropertyPagesImpl<CCommDialog>,
	public IQuickActivateImpl<CCommDialog>,
	public IDataObjectImpl<CCommDialog>,
	public IProvideClassInfo2Impl<&CLSID_CommDialog, &DIID__ICommDialogEvents, &LIBID_SERAPHYSCRIPTTOOLSLib>,
	public IPropertyNotifySinkCP<CCommDialog>,
	public CComCoClass<CCommDialog, &CLSID_CommDialog>
{
public:
	CCommDialog()
	{
		m_pUnkMarshaler = NULL;
		// J[\
		int i;
		for (i = 0; i < 16; i++) {
			m_colors[i] = COLORREF(0xC0C0C0);
		}
		ZeroMemory(&m_color, sizeof(CHOOSECOLOR));
		m_color.lStructSize = sizeof(CHOOSECOLOR);
		m_color.lpCustColors = m_colors;
		m_color.Flags = CC_FULLOPEN | CC_SOLIDCOLOR;
		//
		m_bEnableCreatePrompt = false;
		m_bEnableReadonly = false;
		m_bReadonly = false;
		m_bNoDereferenceLinks = false;
		m_hStaticMainWindow = NULL;  // C^[tFCXD悵Ďgp
		// C^[tFCX̏
		m_pMainWindow = NULL;
	}

	DECLARE_GET_CONTROLLING_UNKNOWN()
	DECLARE_REGISTRY_RESOURCEID(IDR_COMMDIALOG)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(CCommDialog)
		COM_INTERFACE_ENTRY(ICommDialog)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(IViewObjectEx)
		COM_INTERFACE_ENTRY(IViewObject2)
		COM_INTERFACE_ENTRY(IViewObject)
		COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
		COM_INTERFACE_ENTRY(IOleInPlaceObject)
		COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
		COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
		COM_INTERFACE_ENTRY(IOleControl)
		COM_INTERFACE_ENTRY(IOleObject)
		COM_INTERFACE_ENTRY(IPersistStreamInit)
		COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
		COM_INTERFACE_ENTRY(IConnectionPointContainer)
		COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
		COM_INTERFACE_ENTRY(IQuickActivate)
		COM_INTERFACE_ENTRY(IPersistStorage)
		COM_INTERFACE_ENTRY(IDataObject)
		COM_INTERFACE_ENTRY(IProvideClassInfo)
		COM_INTERFACE_ENTRY(IProvideClassInfo2)
		COM_INTERFACE_ENTRY_AGGREGATE(IID_IMarshal, m_pUnkMarshaler.p)
		COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
	END_COM_MAP()

	BEGIN_PROP_MAP(CCommDialog)
		PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
		PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
		PROP_ENTRY("Caption", DISPID_CAPTION, CLSID_NULL)
		// Example entries
		// PROP_ENTRY("Property Description", dispid, clsid)
		// PROP_PAGE(CLSID_StockColorPage)
	END_PROP_MAP()

	BEGIN_CONNECTION_POINT_MAP(CCommDialog)
		CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	END_CONNECTION_POINT_MAP()

	BEGIN_MSG_MAP(CCommDialog)
		CHAIN_MSG_MAP(CComControl<CCommDialog>)
		DEFAULT_REFLECTION_HANDLER()
	END_MSG_MAP()
	// Handler prototypes:
	//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



	HRESULT FinalConstruct()
	{
		return CoCreateFreeThreadedMarshaler(
			GetControllingUnknown(), &m_pUnkMarshaler.p);
	}

	void FinalRelease()
	{
		ATLTRACE("CommonDialog::FinalRelease\r\n");
		// CEBhEC^[tFCX̉
		if (m_pMainWindow) {
			m_pMainWindow->Release();
			m_pMainWindow = NULL;
		}
		m_pUnkMarshaler.Release();
	}

	CComPtr<IUnknown> m_pUnkMarshaler;

	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		static const IID* arr[] =
		{
			&IID_ICommDialog,
		};
		for (int i = 0; i < sizeof(arr) / sizeof(arr[0]); i++) {
			if (IsEqualGUID(*arr[i], riid))
				return S_OK;
		}
		return S_FALSE;
	}

	// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

	static int CALLBACK BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData);
	_bstr_t m_bstr_BrowseForFolderCaption;
	STDMETHOD(get_BrowseForFolderCaption)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_BrowseForFolderCaption)(/*[in]*/ BSTR newVal);
	STDMETHOD(BrowseForFolder)(/*[in,optional]*/VARIANT caption,/*[in,optional]*/VARIANT varDir,/*[in,optinal]*/VARIANT varMode,/*[out,retval]*/VARIANT* pvarReturn);
	STDMETHOD(get_HWND)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_HWND)(/*[in]*/ long newVal);
	STDMETHOD(get_InitialDir)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_InitialDir)(/*[in]*/ BSTR newVal);
	BOOL m_bNoDereferenceLinks;
	STDMETHOD(get_NoDereferenceLinks)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_NoDereferenceLinks)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_ReadOnly)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_ReadOnly)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_EnableReadOnly)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_EnableReadOnly)(/*[in]*/ BOOL newVal);
	BOOL m_bReadonly;
	BOOL m_bEnableReadonly;
	BOOL m_bEnableCreatePrompt;
	STDMETHOD(get_EnableCreatePrompt)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_EnableCreatePrompt)(/*[in]*/ BOOL newVal);
	_bstr_t m_bstr_InitialDir;
	_bstr_t m_bstr_SaveFileCaption;
	_bstr_t m_bstr_OpenFileCaption;
	STDMETHOD(get_SaveFileCaption)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_SaveFileCaption)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_OpenFileCaption)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_OpenFileCaption)(/*[in]*/ BSTR newVal);
	STDMETHOD(SaveFileDialog)(/*[in,optional]*/VARIANT varPathName,/*[in,optional]*/VARIANT varFilter,/*[out,retval]*/VARIANT* pvarReturn);
	STDMETHOD(OpenFileDialog)(/*[in,optional]*/VARIANT varPathName,/*[in,optional]*/VARIANT varFilter,/*[out,retval]*/VARIANT* pvarReturn);
	STDMETHOD(MultiOpenFileDialog)(/*[in,optional]*/VARIANT varMulti,/*[in,optional]*/VARIANT varFilter,/*[out,retval]*/VARIANT* pvarResult);
	void CommFileDialog(VARIANT* pvarResult, VARIANT varPathName, VARIANT varFilter, BOOL bMode, DWORD flags);

	// ICommDialog
public:
	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT& rc = *(RECT*)di.prcBounds;
		Rectangle(di.hdcDraw, rc.left, rc.top, rc.right, rc.bottom);

		SetTextAlign(di.hdcDraw, TA_CENTER | TA_BASELINE);
		LPCTSTR pszText = _T("ATL 3.0 : CommDialog");
		TextOut(di.hdcDraw,
			(rc.left + rc.right) / 2,
			(rc.top + rc.bottom) / 2,
			pszText,
			lstrlen(pszText));

		return S_OK;
	}
	CComBSTR m_bstrCaption;

public:
	STDMETHOD(ColorDialog)(/*[out,retval]*/VARIANT* pcolorVal);
	STDMETHOD(get_MessageCaption)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_MessageCaption)(/*[in]*/ BSTR newVal);
	ATL::CString GetMainCaption();
	STDMETHOD(MessageBox)(/*[in]*/VARIANT mes,/*[in,optional]*/VARIANT typ,/*[in,optional]*/VARIANT icon,/*[out,retval]*/VARIANT* pRet);
	STDMETHOD(SetMainWindow)(/*[in]*/VARIANT varUnk);
	HWND GetMainWindow();
	HWND m_hStaticMainWindow;

protected:
	CHOOSECOLOR m_color;
	COLORREF    m_colors[16];
	IOverlappedWindow* m_pMainWindow;
	CComBSTR m_bstr_MessageCaption;
};
