// Draw.cpp : CCanvas ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "Draw.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CCanvas

HRESULT CCanvas::FinalConstruct()
{
	// h֘A
	m_hParent = NULL;

	// ֘A
	m_pPrinterDeviceMode = NULL;
	m_marginWidth = 150; // 1.5Cm̃}[W
	m_marginHeight = 150;

	// C[̏
	for (int i = 0; i < MAXLAYER; i++) {
		m_pComLayer[i] = NULL;
	}
	for (int i = 0; i < MAXLAYER; i++) {
		HRESULT hr = CComObject<CLayer>::CreateInstance(&m_pComLayer[i]);
		if (FAILED(hr)) {
			return hr;
		}
		m_pComLayer[i]->AddRef();
	}

	return S_OK;
}

void CCanvas::FinalRelease()
{
	ATLTRACE("CCanvas::FinalRelease\r\n");
	// v^foCX̉
	if (m_pPrinterDeviceMode) {
		delete m_pPrinterDeviceMode;
		m_pPrinterDeviceMode = NULL;
	}

	// C[IuWFNg̉
	for (int i = 0; i < MAXLAYER; i++) {
		if (m_pComLayer[i] != NULL) {
			m_pComLayer[i]->Release();
			m_pComLayer[i] = NULL;
		}
	}
}

STDMETHODIMP CCanvas::get_Layer(VARIANT varLay, VARIANT *pVal)
{
	// C[IuWFNg̎󂯓n
	CComVariant vLay;
	int nLayer = 0;
	if (SUCCEEDED(vLay.ChangeType(VT_I2, &varLay))) {
		nLayer = vLay.iVal;
	}
	if (!(nLayer >= 0 && nLayer < MAXLAYER) || m_pComLayer[nLayer] == NULL) {
		return Error(IDS_ERR_LAYERBOUND);
	}

	IUnknown* pUnk = NULL;
	if (SUCCEEDED(m_pComLayer[nLayer]->QueryInterface(IID_IUnknown, (void**)&pUnk))) {
		::VariantInit(pVal);
		pVal->vt = VT_UNKNOWN;
		pVal->punkVal = pUnk;
	}
	return S_OK;
}

/////////////////////////////////
// \bhEvpeB
STDMETHODIMP CCanvas::PrintAs(VARIANT print, VARIANT* pRet)
{
	CComVariant varRet, varPrint;
	PRINTDLG pdlg = {0};
	pdlg.lStructSize = sizeof(PRINTDLG);
	pdlg.hwndOwner = m_hParent;
	pdlg.Flags = PD_NOPAGENUMS | PD_RETURNDC;
	if (PrintDlg(&pdlg)) {
		if (pdlg.hDevMode) {
			// vgfoCXp[^[擾
			DWORD siz = GlobalSize(pdlg.hDevMode);
			if (m_pPrinterDeviceMode) {
				delete m_pPrinterDeviceMode;
			}
			DEVMODE *pDevMode = (DEVMODE*)GlobalLock(pdlg.hDevMode);
			m_pPrinterDeviceMode = (DEVMODE*) new BYTE[siz + 1];
			CopyMemory(m_pPrinterDeviceMode, pDevMode, siz);
			// v^ۑ
			StringCchCopy(m_szPrinterName, MAX_PATH, (LPCTSTR)pDevMode->dmDeviceName);
			varRet = pDevMode->dmDeviceName;
			GlobalUnlock(pdlg.hDevMode);
			GlobalFree(pdlg.hDevMode);
		}
		if (pdlg.hDevNames) {
			GlobalFree(pdlg.hDevNames);
		}
		// vg邩ݒ肾?
		BOOL bPrintOut = true;
		if (print.vt != VT_EMPTY && print.vt != VT_NULL && print.vt != VT_ERROR
			&& varPrint.ChangeType(VT_I2, &print) == S_OK) {
			bPrintOut = varPrint.iVal;
		}
		CDC dc;
		dc.m_bPrinting = true;
		dc.m_hDC = pdlg.hDC;
		if (bPrintOut) {
			PrintCore(dc);
		}
		DeleteDC(dc.m_hDC);
	}
	varRet.Detach(pRet);
	return S_OK;
}

STDMETHODIMP CCanvas::Print()
{
	if (!m_pPrinterDeviceMode) {
		// ܂v^foCXI[vĂȂ
		CComVariant dmy;
		PrintAs(dmy, &dmy);
	}
	else {
		// łɎ擾ꂽv^ƃfoCXp[^[ň
		HDC hdc = CreateDC(NULL, m_szPrinterName, NULL, m_pPrinterDeviceMode);
		CDC dc;
		dc.m_hDC = hdc;
		dc.m_bPrinting = true;
		PrintCore(dc);
		DeleteDC(dc.m_hDC);
	}
	return S_OK;
}

BOOL CCanvas::PrintCore(CDC dc)
{
	::SetCursor(::LoadCursor(NULL, IDC_WAIT));
	// v^̃I[v
	DOCINFO dinfo = {0};
	dinfo.cbSize = sizeof(DOCINFO);
	dinfo.lpszDocName = _TEXT("SeraphyScriptTools");
	int nJob = StartDoc(dc.m_hDC, &dinfo);
	StartPage(dc.m_hDC);
	// ͈͂̐ݒ
	SetMapMode(dc.m_hDC, MM_LOMETRIC);
	int width = GetDeviceCaps(dc.m_hDC, PHYSICALWIDTH);
	int height = GetDeviceCaps(dc.m_hDC, PHYSICALHEIGHT);
	SetViewportOrgEx(dc.m_hDC, 0, height, NULL);
	SetWindowOrgEx(dc.m_hDC, -m_marginWidth, -m_marginHeight, NULL);
	// wi[hݒ
	SetBkMode(dc.m_hDC, TRANSPARENT);
	// C[̈
	dc.m_rct.bottom = GetDeviceCaps(dc.m_hDC, VERTSIZE) * 10;
	dc.m_rct.right = GetDeviceCaps(dc.m_hDC, HORZSIZE) * 10;
	dc.m_rct.bottom += -(m_marginHeight * 2); // r[|[g̐ݒŏc]Ă̂LZ
	for (int i = 0; i < MAXLAYER; i++) {
		m_pComLayer[i]->Draw(dc);
	}
	// I
	EndPage(dc.m_hDC);
	EndDoc(dc.m_hDC);
	::SetCursor(::LoadCursor(NULL, IDC_ARROW));
	return true;
}

STDMETHODIMP CCanvas::GetPrinterDefault(VARIANT name)
{
	CComVariant varName;
	ATL::CString szPrinterName(_TEXT(""));
	if (SUCCEEDED(varName.ChangeType(VT_BSTR, &name))) {
		szPrinterName = varName.bstrVal;
	}
	else {
		DWORD namesz = MAX_PATH;
		LPTSTR pName = szPrinterName.GetBufferSetLength(namesz);
		if (!GetDefaultPrinter(pName, &namesz)) {
			// ̃v^Ȃꍇ
			return Error(IDS_ERR_NODEFPRINTER);
		}
		szPrinterName.ReleaseBuffer();
	}

	HANDLE hp;
	if (OpenPrinter(szPrinterName.GetBuffer(), &hp, NULL)) {
		if (m_pPrinterDeviceMode) {
			// ̃obtANA
			delete m_pPrinterDeviceMode;
		}

		// Kvȃp[^[̕ێ
		DWORD sz = (DWORD)DocumentProperties(
			m_hParent, hp, szPrinterName.GetBuffer(), NULL, NULL, 0);
		m_pPrinterDeviceMode = (DEVMODE*)new BYTE[sz + 1];

		DocumentProperties(m_hParent, hp, szPrinterName.GetBuffer(),
			m_pPrinterDeviceMode, NULL, DM_OUT_BUFFER);
		ClosePrinter(hp);

		// v^̕ۑ
		StringCchCopy(m_szPrinterName, MAX_PATH, szPrinterName);
	}
	else {
		// v^̎擾Ɏsꍇ
		return Error(IDS_ERR_PRINTERSETTING);
	}
	return S_OK;
}

STDMETHODIMP CCanvas::get_MarginWidth(long *pVal)
{
	*pVal = m_marginWidth;
	return S_OK;
}

STDMETHODIMP CCanvas::put_MarginWidth(long newVal)
{
	m_marginWidth = newVal;
	return S_OK;
}

STDMETHODIMP CCanvas::get_MarginHeight(long *pVal)
{
	*pVal = m_marginHeight;
	return S_OK;
}

STDMETHODIMP CCanvas::put_MarginHeight(long newVal)
{
	m_marginHeight = newVal;
	return S_OK;
}

void CCanvas::Draw(HDC hdc, RECT& rt)
{
	// }bsO[h
	int md = GetMapMode(hdc);
	SetMapMode(hdc, MM_LOMETRIC);
	POINT oldPort, oldWindow;
	SetViewportOrgEx(hdc, 0, rt.bottom, &oldPort);
	SetWindowOrgEx(hdc, 0, 0, &oldWindow);
	// C[IuWFNgɕ`s킹
	CDC dc;
	dc.m_hDC = hdc;
	dc.m_bPrinting = false;
	dc.m_rct = rt;
	int i;
	for (i = 0; i < MAXLAYER; i++) {
		if (m_pComLayer[i] != NULL) {
			m_pComLayer[i]->Draw(dc);
		}
	}
	SetWindowOrgEx(hdc, oldWindow.x, oldWindow.y, NULL);
	SetViewportOrgEx(hdc, oldPort.x, oldPort.y, NULL);
	SetMapMode(hdc, md);
}

void CCanvas::DetachOwner()
{
	// I[i[EBhEȂȂB
	m_hParent = NULL;
}

void CCanvas::AttachOwner(HWND hParent)
{
	// ̃IuWFNg͊{IɐeIuWFNgɈˑȂB
	// AEBhE̐eq֌W߂ɂ̂ݎw肷B
	m_hParent = hParent;
}

STDMETHODIMP CCanvas::LoadPicture(VARIANT file, VARIANT *punkVal)
{
	::VariantInit(punkVal);
	CComVariant varFile;
	if (varFile.ChangeType(VT_BSTR, &file) != S_OK) {
		return DISP_E_TYPEMISMATCH;
	}
	IPicture* pPicture = NULL;
	if (OleLoadPicturePath(varFile.bstrVal, NULL, 0, NULL, IID_IPicture, (void**)&pPicture) != S_OK) {
		return Error(IDS_ERR_PICTURELOADFAIL);
	}
	punkVal->vt = VT_UNKNOWN;
	punkVal->punkVal = pPicture; // (IUnknown*)
	return S_OK;
}
