#include "stdafx.h"

#include "ArrayUtil.h"


LPCWSTR ArrayUtil::GetNextToken(LPCWSTR pSrc, WCHAR delimiter, BSTR *pRet) throw()
{
	ATLASSERT(pRet);

	if (!pSrc) {
		return NULL;
	}

	LPCWSTR p = pSrc;
	while (*p && *p != delimiter) p++;
	size_t len = p - pSrc;

	if (pRet) {
		*pRet = SysAllocStringLen(pSrc, static_cast<UINT>(len));
	}

	if (!*p) {
		return NULL;
	}
	return p + 1;
}

HRESULT ArrayUtil::DelimitedStringToSafeArray(LPCWSTR pSrc, WCHAR delimiter, VARIANT *pArray) throw()
{
	if (!pArray) {
		return E_POINTER;
	}
	VariantInit(pArray);
	pArray->vt = VT_NULL;

	LPCWSTR p = pSrc;
	if (p == NULL) {
		p = L"";
	}

	// g[Ň𐔂
	ULONG count = 0;
	while (p) {
		CComBSTR token;
		p = GetNextToken(p, delimiter, &token);
		count++;
	}

	// SAFEARRAY쐬
	SAFEARRAY* pArr = SafeArrayCreateVector(VT_VARIANT, 0, count);
	if (pArr == NULL) {
		// mۂłȂꍇ͂Ԃ񃁃s炢?
		return E_OUTOFMEMORY;
	}
	ATLASSERT(pArr->cDims == 1);
	ATLASSERT(pArr->rgsabound[0].lLbound == 0);
	ATLASSERT(pArr->rgsabound[0].cElements == count);

	try {
		p = pSrc;
		if (p == NULL) {
			p = L"";
		}
		for (ULONG idx = 0; idx < count; idx++) {
			LONG rgIndices[] = {idx};

			CComVariant tmp;

			tmp.vt = VT_BSTR;
			p = GetNextToken(p, delimiter, &tmp.bstrVal);

			HRESULT hr = SafeArrayPutElement(pArr, &rgIndices[0], reinterpret_cast<void*>(&tmp));
			if (FAILED(hr)) {
				AtlThrow(hr);
			}
		}

		pArray->vt = VT_VARIANT | VT_ARRAY;
		pArray->parray = pArr;

		return S_OK;

	} catch (CAtlException &ex) {
		SafeArrayDestroy(pArr);
		return ex.m_hr;
	}
}

HRESULT ArrayUtil::GetSafeArrayFromVariant(const VARIANT* pVar, SAFEARRAY **ppSafeArray) throw()
{
	if (!ppSafeArray) {
		return E_POINTER;
	}
	*ppSafeArray = NULL;

	// QƊO
	while (pVar && pVar->vt == (VT_BYREF | VT_VARIANT)) {
		pVar = pVar->pvarVal;
	}

	// NULL
	if (IsNullOrError(pVar)) {
		// NULL܂ERROR/EMPTY̏ꍇ́AS_FALSEԂB
		return S_FALSE;
	}

	if (!(pVar->vt & VT_ARRAY) && (pVar->vt != VT_SAFEARRAY)) {
		// SAFEARRAYzȊÓADISP_E_TYPEMISMATCHԂB
		return DISP_E_TYPEMISMATCH;
	}

	// SAFEARRAY擾
	SAFEARRAY *pSafeArray;
	if (pVar->vt & VT_BYREF) {
		pSafeArray = *pVar->pparray;
	} else {
		pSafeArray = pVar->parray;
	}
	if (!pSafeArray) {
		return E_INVALIDARG;
	}

	ATLASSERT(!*ppSafeArray);
	*ppSafeArray = pSafeArray;

	return S_OK;
}
