package noguchi.SentenceLearner;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import android.widget.CompoundButton.OnCheckedChangeListener;
//import android.graphics.Color;

public class CheckedListAdapter extends ArrayAdapter<ListItem>{
	private LayoutInflater mInflater;
	private TextView mTitle;
	private CheckBox mCheckBox;
	private boolean isAllChecked;
	private CheckedListListener checkedListListener;
		
	public CheckedListAdapter(Context context, List<ListItem> objects, boolean isAllChecked, CheckedListListener checkedListListener) {
		super(context, 0, objects);
		mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.isAllChecked = isAllChecked;
		this.checkedListListener = checkedListListener;
	}
	public View getView(final int position, View convertView, ViewGroup parent) {
				
		if (convertView == null) {
			convertView = mInflater.inflate(R.layout.checkedlistrow, null);
		}
		
		final ListItem item = this.getItem(position);
		
		if(item != null){
			mTitle = (TextView)convertView.findViewById(R.id.ItemName);
			mTitle.setText(item.getName());
			mCheckBox = (CheckBox)convertView.findViewById(R.id.CheckBox);
			mCheckBox.setChecked(isAllChecked);
			item.setChecked(isAllChecked);
			
			//mTitle.setTextColor(Color.RED);
			
			mTitle.setOnClickListener(new SelectedListener(item, checkedListListener));
			mCheckBox.setOnCheckedChangeListener(new OnCheckedListener(item));
		}
		return convertView;
	}
}

class SelectedListener implements OnClickListener
{
	private CheckedListListener checkedListListener;
	private ListItem item;

	public SelectedListener(ListItem item, CheckedListListener checkedListListener){
		this.item = item;
		this.checkedListListener = checkedListListener;
	}
	@Override
	public void onClick(View v) {
		checkedListListener.OnCheckedListClick(item);
	}
}

class OnCheckedListener implements OnCheckedChangeListener
{
	private ListItem item;
	public OnCheckedListener(ListItem item){
		this.item = item;
	}
	@Override
	public void onCheckedChanged(CompoundButton arg0, boolean arg1) {
		item.setChecked(arg1);
	}
}
