﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include "Foundation.h"


namespace bearmini
{
    ///
    ///  プログラムを実行するためのクラスです。
    ///
    class Program
    {
    public:
        Program() {};
        virtual ~Program() throw() {};

        // プログラムを実行するためのインスタンスを作成する
        static Program* Create();

        // プログラムを実行する
        virtual void Run(const wstring_vector& args) = 0;

        // プログラムをインストール/アンインストールする
        virtual void Setup() = 0;

        // ユーザにわかりやすい名前を返す
        virtual std::wstring GetUserFriendlyName() const = 0;

    private:
        // プログラムの実行ファイル名（拡張子なし）を得る
        static std::wstring getExeFileNameWithoutExt();

    };

}
