﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include <string>

#include "Foundation.h"


namespace bearmini
{
    ///
    ///  コンソールプロセスを専門的に扱うためのクラスです。
    ///
    class Process
    {
    public:
        explicit Process(const std::wstring& path);
        Process(const std::wstring& path, const std::wstring& workDir);
        virtual ~Process() throw();

        void Run(bool asAdmin = false);
        void WaitForConsoleAllocated();

        inline ::DWORD GetId() { return ::GetProcessId(m_hProcess); }
        inline ::HANDLE GetHandle() { return m_hProcess; }

    private:
        void run();
        void runAsAdmin();

        std::wstring m_path;
        std::wstring m_workDir;
        ::HANDLE m_hProcess;
        ::HANDLE m_hThread;
    };

}
