﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include "ConsoleInputArray.h"
#include "Program.h"


namespace bearmini 
{
    ///
    ///  「コマンドプロンプトに送る」の機能を実装しているクラスです。
    ///
    class SendToCMD : public Program
    {
    public:
        SendToCMD() {};
        virtual ~SendToCMD() throw() {};

        ///
        ///  指定されたファイル名は SendToCMD.exe の名前かどうかを取得します。
        ///  渡される name はファイル名のベース名部分のみ
        ///
        ///  @param[in] name EXE ファイルのファイル名部分（拡張子なし）
        ///
        ///  @return 指定された名前が SendToCMD なら true、そうでなければ false
        ///
        static bool IsMyExeName(const std::wstring& name)
        {
            return name.compare(L"SendToCMD") == 0;
        }

        ///
        ///  このプログラムの名前を取得します。
        ///  この名前がメッセージボックスのタイトルなどに使われます。
        ///
        ///  @return このプログラムの名前
        ///
        std::wstring GetUserFriendlyName() const
        {
            return L"コマンドプロンプトに送る";
        }


        void Run(const wstring_vector& args);
        void Setup();

    private:
        void validateArguments(const wstring_vector& args);

        std::wstring generateCommandLine();
        std::wstring getCmdExePath();
        std::wstring getAdditionalParam();

        std::wstring getConsoleTitle(bool isAdminProcess);

        std::wstring getWorkDirectoryFor(const std::wstring& path);
        void arrangeConsoleInputArray(const std::wstring& path, ConsoleInputArray* pConsoleInputArray);

        std::wstring getSendToCmdExeFullPath();
        std::wstring getSendToCmdExeDirectory();

        void install();
        void uninstall();

    };

}