﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "ConsoleInputArray.h"

namespace bearmini
{
    ///
    ///  コンストラクタ。
    ///  wstring から構築します。
    ///
    ConsoleInputArray::ConsoleInputArray(const std::wstring& str)
    {
        Append(str);
    }


    ///
    ///  デストラクタ。
    ///
    ConsoleInputArray::~ConsoleInputArray()
    {
    }


    ///
    ///  キー入力配列に文字列を追加します。
    ///
    void ConsoleInputArray::Append(const std::wstring& str)
    {
        for (std::size_t i = 0; i < str.size(); i++)
        {
            // KEYDOWN
            INPUT_RECORD ir;
            ir.EventType = KEY_EVENT;
            ir.Event.KeyEvent.bKeyDown          = TRUE;
            ir.Event.KeyEvent.wRepeatCount      = 1;
            ir.Event.KeyEvent.wVirtualKeyCode   = 0;
            ir.Event.KeyEvent.wVirtualScanCode  = 0;
            ir.Event.KeyEvent.uChar.UnicodeChar = str.at(i);
            ir.Event.KeyEvent.dwControlKeyState = 0;
            m_inputArray.push_back(ir);

            // KEYUP
            ir.Event.KeyEvent.bKeyDown = FALSE;
            m_inputArray.push_back(ir);
        }
    }


    ///
    ///  キー入力配列にバーチャルキーコードで指定されたキーを追加します。
    ///
    void ConsoleInputArray::AppendVirtualKeyCode(::WORD wVirtualKeyCode, unsigned int nTimes)
    {
        for (unsigned int i = 0; i < nTimes; i++)
        {
            // KEYDOWN
            INPUT_RECORD ir;
            ir.EventType = KEY_EVENT;
            ir.Event.KeyEvent.bKeyDown          = TRUE;
            ir.Event.KeyEvent.wRepeatCount      = 1; // <- ここに nTimes を入れれば、ループしなくてもうまくいきそうだが、ダメだった
            ir.Event.KeyEvent.wVirtualKeyCode   = wVirtualKeyCode;
            ir.Event.KeyEvent.wVirtualScanCode  = 0;
            ir.Event.KeyEvent.uChar.UnicodeChar = 0;
            ir.Event.KeyEvent.dwControlKeyState = 0;
            m_inputArray.push_back(ir);

            // KEYUP
            ir.Event.KeyEvent.bKeyDown = FALSE;
            m_inputArray.push_back(ir);
        }
    }

}
