/**
 * 
 */
package jp.mydns.masahase.abaqus;

import java.io.EOFException;
import java.io.FileNotFoundException;

/**
 * {@link ReadAscFil}と{@link ReadBinFil}のラッパークラス
 * 
 * @author MASA.H
 * @version 1.0
 * 
 */
final public class ReadFil implements IReadFil {
	private transient IReadFil ir_fil;
	private transient String fname;

	/**
	 * デフォルトコンストラクタ
	 */
	public ReadFil() {
		try {
			setFileName("Job-1.fil");
		} catch (FileNotFoundException e) {
			fname = "";
		}
	}

	public void setFileName(final String fname0) throws FileNotFoundException {
		fname = fname0;
		ir_fil = new ReadBinFil();
		ir_fil.setFileName(fname);
		if (!ir_fil.isType()) {
			ir_fil = new ReadAscFil();
			ir_fil.setFileName(fname);
		}
	}

	public int getNextRecordKey() throws EOFException {
		return ir_fil.getNextRecordKey();
	}

	public Object[] getRecordContents() {
		return ir_fil.getRecordContents();
	}

	public void rewind() {
		ir_fil.rewind();
	}

	public boolean isType() {
		return ir_fil.isType();
	}

}
