/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ResourceBundle;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;

public abstract class Configuration {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.sun.security.auth.Resources");
    private static Configuration configuration;
    private static ClassLoader sysClassLoader;
    static /* synthetic */ Class class$javax$security$auth$login$Configuration;

    protected Configuration() {
    }

    public static Configuration getConfiguration() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        if (configuration == null) {
            Class clazz = class$javax$security$auth$login$Configuration == null ? (class$javax$security$auth$login$Configuration = Configuration.class$("javax.security.auth.login.Configuration")) : class$javax$security$auth$login$Configuration;
            synchronized (clazz) {
                if (configuration == null) {
                    String string = null;
                    string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Security.getProperty("login.configuration.provider");
                        }
                    });
                    if (string == null) {
                        string = "com.sun.security.auth.login.ConfigFile";
                    }
                    try {
                        configuration = (Configuration)Class.forName(string, true, sysClassLoader).newInstance();
                    }
                    catch (Exception exception) {
                        throw new SecurityException(rb.getString("unable to instantiate Login Configuration"));
                    }
                }
            }
        }
        return configuration;
    }

    public static void setConfiguration(Configuration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        Configuration.configuration = configuration;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }
}

