package jp.mydns.masahase.abaqus.weldline;

import jp.mydns.masahase.InherentStrain.InherentStrainType;
import java.io.FileInputStream;

public class StraightLineMirror extends StraightLine {

	public StraightLineMirror(InherentStrainType pedata, double[] StartPos,
			double[] EndPos, double[] RefPos) {
		super(pedata, StartPos, EndPos, RefPos);
	}
	@Override
	public double[] getPE(double x, double y, double z) {
		double[] ret = new double[6];
		double[] coord = changeCoordinate(x, y, z);
		for (int i = 0; i < ret.length; i++) {
			ret[i] = 0;
		}
		coord[0]=Math.abs(coord[0]);
		getPE_(ret, coord);
		ret=changeECoordinate(ret);
		return ret;
	}
    public static void main(String[] args) {
        double[] start, end, ref;
        start = new double[3];                                                                             
        end = new double[3];
        ref = new double[3];
        start[0] = 0.0;
        start[1] = 0.0;
        start[2] = 0.0;
        end[0] = 0.0;
        end[1] = 500.0;
        end[2] = 0.0;
        ref[0] = 0.0;
        ref[1] = 0.0;
        ref[2] = 1.0;
        StraightLineMirror sl=new StraightLineMirror(null, start, end, ref);

        if(args.length>0){
            try{
                jp.mydns.masahase.InherentStrain.InherentStrainType ist =
                    (new jp.mydns.masahase.operateXML.InherentStrainUnMarshaller
                     (new FileInputStream(args[0]))).call();
                sl = new StraightLineMirror(ist, start, end, ref);
            }catch(Exception e){
                e.printStackTrace();
            }
        }

        double[] tmp=sl.getPE(-1,0,1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(1,0,1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(-10,0,1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(10,0,1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(-10,0,-1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(10,0,-1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(-1,0,-1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(1,0,-1);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(-2,0,-5.2);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");
        tmp=sl.getPE(2,10,-4.8);
        for(int i=0;i<6;i++){
            System.out.print(tmp[i]);
            System.out.print("\t");
        }
        System.out.print("\n");

    }
}
