/**
 * 
 */
package jp.mydns.masahase.abaqus.weldline;

import java.util.ArrayList;
import java.util.concurrent.Callable;

import jp.mydns.masahase.sdes.common.FemFunc;

/**
 * 複数の線で構成される線
 * 
 * @author Masahiro
 * 
 */
public class CompositeLine implements IWeldLine {
	protected ArrayList<IWeldLine> aliwl;

	public CompositeLine() {
		aliwl = new ArrayList<IWeldLine>();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.mydns.masahase.abaqus.weldline.IWeldLine#getPE(double, double,
	 * double)
	 */
	@Override
	public double[] getPE(double x, double y, double z) {
		double[] ret = new double[6];
		int[] size = new int[6];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = 0;
			size[i] = 0;
		}
		double[][] wlist = new double[aliwl.size()][];
		for (int i = 0; i < aliwl.size(); i++) {
			try {
				wlist[i] = (new GetPE(aliwl.get(i), x, y, z)).call();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		for (double[] tmp : wlist) {
			for (int i = 0; i < tmp.length; i++) {
				if (!Double.isNaN(tmp[i]) && !Double.isInfinite(tmp[i])
						&& tmp[i] != 0) {
					ret[i] += tmp[i];
					size[i]++;
				}
			}
		}
		/*for (int i = 0; i < ret.length; i++) {
			if (size[i] != 0) {
				ret[i] /= size[i];
			}
		}*/
		if(FemFunc.calcEstimateStrain(ret)>0.1){
			System.out.println(FemFunc.calcEstimateStrain(ret));
			for(double[] tmp:wlist){
				for(double t:tmp){
					System.out.print(t);
				}
				System.out.print("\n");
			}
		}
		assert FemFunc.calcEstimateStrain(ret)<0.1;
		return ret;
	}

	public boolean add(IWeldLine iwl) {
		return aliwl.add(iwl);
	}

	class GetPE implements Callable<double[]> {
		public GetPE(IWeldLine iwl, double x, double y, double z) {
			this.iwl = iwl;
			this.x = x;
			this.y = y;
			this.z = z;
		}

		IWeldLine iwl;
		double x, y, z;

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.util.concurrent.Callable#call()
		 */
		@Override
		public double[] call() throws Exception {
			return iwl.getPE(x, y, z);
		}

	}
}
