#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" scionleave.py: Graphical confirmation dialogue """

__author__ = "Dorian"
__version__ = "0.41"
__maintainer__ = "Dorian"
__email__ = "doriang2015@outlook.com"

import os
import wx

PANSHOWN = False
Prim = True
OpenX = 0
OpenY = 0


class lFrame(wx.Frame):
    def __init__(self):
        style = (wx.CLIP_CHILDREN | wx.STAY_ON_TOP | wx.FRAME_NO_TASKBAR |
                 wx.NO_BORDER | wx.FRAME_SHAPED)
        wx.Frame.__init__(self, None, title='Confirm', style=style, size=(150, 900))
        self.SetTransparent(210)
        global PANSHOWN

        panel = wx.Panel(self, style=wx.SIMPLE_BORDER)
        panel.SetBackgroundColour('#555555')
        panel.Bind(wx.EVT_MOTION, self.noTip)
        box = wx.BoxSizer(wx.HORIZONTAL)

        box.AddStretchSpacer()
        
        imgpan = wx.Panel(panel)
        imgpan.SetBackgroundColour('#555555')
        img = wx.StaticBitmap(imgpan)
        img.SetBitmap(wx.Bitmap(os.path.split(os.path.abspath(__file__))[0] + "/logout.png"))
        img.Bind(wx.EVT_LEFT_DOWN, self.onLog)
        img.Bind(wx.EVT_MOTION, self.onLogmouse)
        box.Add(imgpan, 0, wx.CENTER, 30)
        
        box.AddSpacer(20)
        
        imgpan2 = wx.Panel(panel)
        imgpan2.SetBackgroundColour('#555555')
        img2 = wx.StaticBitmap(imgpan2)
        img2.SetBitmap(wx.Bitmap(os.path.split(os.path.abspath(__file__))[0] + "/restart.png"))
        img2.Bind(wx.EVT_LEFT_DOWN, self.onReb)
        img2.Bind(wx.EVT_MOTION, self.onRebmouse)
        box.Add(imgpan2, 0, wx.CENTER, 30)

        box.AddSpacer(20)
        
        imgpan3 = wx.Panel(panel)
        imgpan3.SetBackgroundColour('#555555')
        img3 = wx.StaticBitmap(imgpan3)
        img3.SetBitmap(wx.Bitmap(os.path.split(os.path.abspath(__file__))[0] + "/shutdown.png"))
        img3.Bind(wx.EVT_LEFT_DOWN, self.onShut)
        img3.Bind(wx.EVT_MOTION, self.onShutmouse)
        box.Add(imgpan3, 0, wx.CENTER, 30)

        box.AddStretchSpacer()

        panel.SetSizer(box)
        panel.Layout()

        # self.Show(True)
        PANSHOWN = True

    def OnChange(self, event):
        global x, y, fx, fy, za, zb, cw, ch
        x, y = f.GetPosition()
        fx, fy = f.GetSize()
        za, zb, cw, ch = wx.GetClientDisplayRect()
        self.timer = wx.Timer(self, wx.ID_ANY)
        self.timer.Start(10)
        self.Bind(wx.EVT_TIMER, slidePan)
    
    def onClic(self, event):
		print "CLICKED"
    
    def noTip(self, event):
        self.SetToolTipString('')
		
    def onRebmouse(self, event):
        self.SetToolTipString('Restart the computer')

    def onShutmouse(self, event):
        self.SetToolTipString('Shutdown the computer')
        
    def onLogmouse(self, event):
        self.SetToolTipString('Logout')

    def onLog(self, event):
        os.system('openbox --exit')

    def onReb(self, event):
        os.system('reboot')

    def onShut(self, event):
        os.system('shutdown now')


def alignToBottomRight(win):
    global OpenX
    global OpenY
    dw, dh = wx.DisplaySize()
    za, zb, cw, ch = wx.GetClientDisplayRect()
    w, h = win.GetSize()
    h = 120
    w = cw
    win.SetSize((w, h))
    x = dw - w
    y = dh - h
    win.SetPosition((x, y))
    OpenX = x
    OpenY = y


def slidePan(self):
    global x, y, fx, fy, za, zb, cw, ch
    global OpenX
    global OpenY
    global PANSHOWN
    global Prim
    if PANSHOWN:
        fy -= 5
        y += 5
        f.SetSizeWH(fx, fy)
        f.SetPosition((x, y))
        if y > ch + 50:
            PANSHOWN = False
            f.timer.Stop()
            f.Raise()
            if Prim:
                Prim = False
                f.OnChange(self)
            else:
                print "Not Prim, exiting"
                f.Destroy()
                exit()
    else:
        fy += 5
        y -= 5
        f.SetPosition((x, y))
        f.SetSizeWH(fx, fy)
        if y <= OpenY:
            f.SetSizeWH(fx, 120)
            PANSHOWN = True
            f.timer.Stop()
            f.Raise()


class App(wx.App):
    def OnInit(self):
        self.Bind(wx.EVT_KILL_FOCUS, self.onKillFocus)
        frame = wx.Frame(None)
        self.SetTopWindow(frame)
        return True

    def onKillFocus(self, event):
        f.OnChange(self)
        print "widget lost focus!"


app = App(False)
f = lFrame()
alignToBottomRight(f)
f.OnChange(f)
app.MainLoop()
