#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" iron.py: Scion Update Notification/Install Utility """

__author__ = "Dorian"
__version__ = "0.52"
__maintainer__ = "Dorian"
__email__ = "doriang2015@outlook.com"

# This script depends on the update-manager package

import os
import threading
import time as time
import wx
from subprocess import Popen, PIPE
import sys

# Set initial variables
TRAY_TOOLTIP = 'Iron'
trayIcon = '/usr/share/icons/Moka/32x32/emblems/emblem-synchronizing.png'
tLock = threading.Lock()
checkTimer = 600 # How many seconds in between checks (default 10 mins)
shutdown = False # Value that poller thread checks
showedonce = False # Prevents notification being shown repeatedly
reqUpgrade = False # Set to true to make thread upgrade
reqCheck = False # Set to true to check for updates
manCheck = False # Is check manually requested?
netError = False # Network error present
upcount = 0
ustatus = 0 # 0=no update, 1=checking, 2=updates, 3=installing
cstatus = 0 # Current status to compare to ustatus

def poller():
    # poller : This is the thread that does all the background work
    global upcount
    global showedonce
    global reqUpgrade
    global reqCheck
    global manCheck
    counter = 0
    reqCheck = True # Initially treated as manual check
    print('Poller thread started')

    def docheck():
        # Check for available updates
        global manCheck
        global reqCheck
        global upcount
        global netError
        global ustatus
        print "DO update"
        ustatus = 1 
        if manCheck:
            notify("Checking for updates...")
        # Request apt daemon to check for updates
        runcheck = Popen(["aptdcon -c"], stdout=PIPE, shell=True)
        (checkstat, err) = runcheck.communicate()
        print "DO check update count"
        print checkstat
        # If there is a network error
        if "ERROR: Failed to download repository information" in checkstat:
            netError = True
            print "Net ERROR"
        # Simulate upgrade and get count of package updates
        ustatus = 0
        p1 = Popen(["""apt-get upgrade -s |grep -P '^\d+ upgraded'|cut -d" " -f1"""], stdout=PIPE, shell=True)
        (out, err) = p1.communicate()
        if not netError:
            ustatus = 2
            if int(out) == 0:
                ustatus = 0
            print out, " available updates"
        if netError and not manCheck:
            time.sleep(2)
            notify("There is no network connection")
        upcount = str(out).rstrip()
        reqCheck = False
        if (manCheck) and (int(upcount) == 0) and not (netError):
            ustatus = 0
            notify("Your system is up to date!")
            manCheck = False
        if netError and manCheck:
            notify("No network connection")
            manCheck = False
            netError = False

    def doupgrade():
        global showedonce
        global reqUpgrade
        global reqCheck
        ustatus = 3
        runcheck = Popen(["update-manager"], stdout=PIPE, shell=True)
        (checkstat, err) = runcheck.communicate()
        showedonce = False
        reqUpgrade = False
        time.sleep(2)
        reqCheck = True
        ustatus = 0

    while not shutdown:  # Loop as long as the SHUTDOWN is not set to true
        if reqCheck: # If set to true, manually requested
            ustatus = 1
            docheck()
        if (not showedonce) and (int(upcount) > 0) and not (netError):  # Not showed yet, more than 0 updates
            ustatus = 2
            notify('There are ' + upcount + ' updates available.')
            print "There are ", upcount
            print netError
            showedonce = True  # Do not re-show again
        time.sleep(2)
        counter = counter + 2
        if counter >= checkTimer:  # 10 minutes passed, check updates again
            reqCheck = True # Triggers check
            counter = 0 # Reset timer
        if reqUpgrade: # manually requested upgrade
            doupgrade()
    print('Poller shutting down')


def notify(message):
    # Make a popup notification
    msg = ('notify-send "Scion Updater" "' + message +
           '" -i /opt/scion/scion-planets-64.png' +
           ' -h string:synchronous:anything')
    print(msg)
    os.system(msg)


def create_menu_item(menu, label, func):
    # Create easy menu items
    item = wx.MenuItem(menu, -1, label)
    menu.Bind(wx.EVT_MENU, func, id=item.GetId())
    menu.AppendItem(item)
    return item


class TaskBarIcon(wx.TaskBarIcon):
    def __init__(self, frame):
        # Setup the system tray
        self.frame = frame
        super(TaskBarIcon, self).__init__()
        self.set_icon(trayIcon) # Set icon, need to change later
        self.Bind(wx.EVT_TASKBAR_LEFT_DOWN, self.on_left_down)

    def CreatePopupMenu(self):
        # Generate right-click menu
        global upcount
        self.menu = wx.Menu()
        self.menu.chk = self.menu.Append(101, 'Automatic Checking', 'Check for updates', kind=wx.ITEM_CHECK)
        self.menu.Check(101, True)
        self.Bind(wx.EVT_MENU, self.on_tog, id=101)
        self.menu.chkups = self.menu.Append(102, 'Check Now', 'Check Now')
        self.Bind(wx.EVT_MENU, self.on_checknow, id=102)
        self.menu.chknow = self.menu.Append(103, 'Check Now', 'Check Now')
        self.Bind(wx.EVT_MENU, self.on_checknow, id=103)
        self.menu.chkups.SetItemLabel(upcount + " updates are available")
        if reqCheck or manCheck: # Change label depending
            self.menu.chkups.SetItemLabel("Checking for updates...")
        if reqUpgrade: # Change label depending
            self.menu.chkups.SetItemLabel("Installing updates...")
        create_menu_item(self.menu, 'Install updates', self.on_install)
        self.menu.AppendSeparator()
        create_menu_item(self.menu, 'Exit', self.on_exit)
         # Check the status of the poller thread, set checkbox accordingly
        if shutdown:
            self.menu.Check(101, False)
        else:
            self.menu.Check(101, True)
        return self.menu

    def set_icon(self, path):
        icon = wx.IconFromBitmap(wx.Bitmap(path))
        self.SetIcon(icon, TRAY_TOOLTIP)

    def on_left_down(self, event):
        # Left-click shows update status
        print('Tray icon was left-clicked.')
        if upcount >= 1:
            notify('There are ' + upcount + ' updates available.')
        elif upcount == 0:
            notify('Your system is up to date!')

    def on_checknow(self, event):
        global ustatus
        ustatus = 1
        # Sets values for poller thread to take action
        global manCheck
        global reqCheck
        manCheck = True
        reqCheck = True

    def on_tog(self, event):
        # Toggle boolean for poller, start thread if needed.
        global shutdown
        if shutdown:
            shutdown = False  # Not shutdown, IE running
            uT = threading.Thread(target=poller)
            uT.start()
        else:
            shutdown = True

    def on_install(self, event):
        global ustatus
        ustatus = 3
        # Give notifications and set values for poller thread to take action
        
        notify("Installing updates...")
        print('Installing updates...')
        global reqUpgrade
        reqUpgrade = True

    def on_exit(self, event):
        # Exiting
        global shutdown
        shutdown = True # Tell poller thread to shutdown
        # Destroy windows and close
        sys.exit(0)
        wx.CallAfter(self.Destroy)
        self.frame.Close()


class App(wx.App):
    def OnInit(self):
        global tbi
        # Create widgets with class creation
        frame = wx.Frame(None)
        self.SetTopWindow(frame)
        tbi = TaskBarIcon(frame)
        return True
        
    def MainLoop(self):
        global upcount
        global cstatus
        global ustatus
        global trayIcon
        self.keepGoing = True
        if "wxMac" in wx.PlatformInfo:
            # Skip if on Mac
            wx.App.MainLoop()
        else:
            # Create an event loop and make it active.  
            evtloop = wx.EventLoop()
            old = wx.EventLoop.GetActive()
            wx.EventLoop.SetActive(evtloop)
            while self.keepGoing:
                # Run tasks in mainloop
                time.sleep(1) # To prevent high CPU usage
                if ustatus != cstatus:
                    # 0=no update, 1=checking, 2=updates, 3=installing
                    cstatus = ustatus
                    if ustatus == 0:
                        trayIcon = '/usr/share/icons/gnome/24x24/actions/stock_top.png'
                        tbi.set_icon(trayIcon)
                    if ustatus == 1:
                        trayIcon = '/usr/share/icons/Moka/32x32/emblems/emblem-synchronizing.png'
                        tbi.set_icon(trayIcon)
                    if ustatus == 2:
                        trayIcon = '/usr/share/icons/Moka/32x32/emblems/emblem-important.png'
                        tbi.set_icon(trayIcon)
                    if ustatus == 3:
                        trayIcon = '/usr/share/icons/Moka/32x32/emblems/emblem-synchronizing.png'
                        tbi.set_icon(trayIcon)                          
                # Process any waiting GUI events
                while evtloop.Pending():
                    evtloop.Dispatch()
                # Send idle events to idle handlers.
                self.ProcessIdle()
            wx.EventLoop.SetActive(old)

def main():
    # Start poller thread and create new App class
    uT = threading.Thread(target=poller)
    uT.start()
    app = App(False)
    app.MainLoop()


if __name__ == '__main__':
    main()

print('Quitting')
