#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" scioncp.py: Control Panel for Scion """

__author__ = "Dorian"
__version__ = "0.53"
__maintainer__ = "Dorian"
__email__ = "doriang2015@outlook.com"

import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk
import os
import subprocess
import sys


br = 100
ver = "null"
cname = "null"

if len(sys.argv) > 1:
    if sys.argv[1] == "--leave":
        print "Leaving", os.path.split(os.path.abspath(__file__))[0] + '/scionleave.py'
        os.system(os.path.split(os.path.abspath(__file__))[0] + '/scionleave.py')
        exit()


class scp(object):
    def __init__(self):
        global ver
        global cname
        self.builder = Gtk.Builder()
        self.builder.add_from_file(os.path.split(os.path.abspath(__file__))[0] + "/controlpanel.glade")
        self.builder.connect_signals(self)
        self.builder.get_object("winMain").set_title("Scion")
        
        with open("/etc/os-release") as fil:
            for line in fil:
                print line
                try:
                    conf, v = line.rstrip().split("=")
                except:
                    print "Version parsing error"
                
                if conf == "VERSION_ID":
                    ver = v.strip('"')
        if ver == "18.1":
            cname = "(Sol)"
        if ver == "18.1.1":
            cname = "(Sol)"           
        if ver == "18.2":
            cname = "(Mercury)"
        if ver == "18.2.4":
            cname = "(Mercury)"
        if ver == "18.2.6":
            cname = "(Mercury)"
        if ver == "18.3":
            print "code set"
            cname = "(Venus)"
        fname = "Scion " + ver + " " + cname
        print fname
        self.builder.get_object("label6").set_label(fname)
        
        try:
            p = subprocess.Popen("xbacklight -get", stdout=subprocess.PIPE, shell=True)
            (output, err) = p.communicate()
            output2 = int(float(output.strip()))
            print output2
            self.builder.get_object("slBrightness").set_value(int(output2))
            print output
        except:
            print "xbacklight not found"
            self.builder.get_object("slBrightness").hide()
            self.builder.get_object("lblTitle").hide()
        try:
            p = subprocess.Popen("synclient -l | grep Touch | grep -o '[0-9]*'", stdout=subprocess.PIPE, shell=True)
            (output, err) = p.communicate()
            output = int(output.strip())
            if output == 0:
                self.builder.get_object("chkTouchPad").set_active(True)
        except:
            self.builder.get_object("lblTouchPad").hide()
            self.builder.get_object("chkTouchPad").hide()

    def run(self):
        self.builder.get_object("winMain").show()
        print "Window open"

    def on_winMain_destroy(self, *args):
        print "Window closed"
        Gtk.main_quit()

    def on_btUpdate_clicked(self, *args):
        os.system(os.path.split(os.path.abspath(__file__))[0] + '/iron.py &')
  
    def on_btWallpaper_clicked(self, *args):
        os.system('nitrogen &')

    def on_btLookFeel_clicked(self, *args):
        os.system('lxappearance &')

    def on_btObconf_clicked(self, *args):
        os.system('obconf &')

    def on_btTint2_clicked(self, *args):
        os.system('tint2conf &')

    def on_btCompton_clicked(self, *args):
        os.system(os.path.split(os.path.abspath(__file__))[0] + '/togcomp &')

    def on_btGreeter_clicked(self, *args):
        os.system('lightdm-gtk-greeter-settings-pkexec &')

    def on_btScreensaver_clicked(self, *args):
        os.system('xscreensaver-demo &')

    def on_btDock_clicked(self, *args):
        os.system('plank --preferences &')

    def on_btPower_clicked(self, *args):
        os.system('mate-power-preferences &')

    def on_btTimeDate_clicked(self, *args):
        os.system('time-admin &')

    def on_btPrinters_clicked(self, *args):
        os.system('system-config-printer &')

    def on_btNetworkSet_clicked(self, *args):
        os.system('network-admin &')

    def on_btInput_clicked(self, *args):
        os.system('lxinput &')

    def on_btKeymap_clicked(self, *args):
        os.system('lxkeymap &')

    def on_btNetworkCon_clicked(self, *args):
        os.system('nm-connection-editor &')

    def on_btNetworkCon_clicked(self, *args):
        os.system('nm-connection-editor &')

    def on_btScreenRes_clicked(self, *args):
        os.system('lxrandr &')

    def on_btSysBack_clicked(self, *args):
        os.system('systemback-sustart &')

    def on_btGparted_clicked(self, *args):
        os.system('gparted-pkexec &')

    def on_btUsersGroups_clicked(self, *args):
        os.system('users-admin &')

    def on_btSoftware_clicked(self, *args):
        os.system('synaptic-pkexec &')

    def on_slBrightness_value_changed(self, *args):
        br = int(self.builder.get_object("slBrightness").get_value())
        os.system('xbacklight -set ' + str(br) + ' &')

    def on_chkTouchPad_toggled(self, *args):
        if self.builder.get_object("chkTouchPad").get_active():
            os.system('synclient TouchpadOff=0 ' + str(br) + ' &')
        else:
            os.system('synclient TouchpadOff=1 ' + str(br) + ' &')


scp().run()

if __name__ == '__main__':
    Gtk.main()
