
#include <stdio.h>
#include <syslog.h>
#include <unistd.h>
#include <string.h>

#include "ad_ring.h"
#include "sts.h"
#include "debug_print.h"
#include "ad_file.h"

// 1secファイル書き込み間隔　sec
//#define	SEC_FLUSH_NUM	1
#define	SEC_FLUSH_NUM	60

// 高速サンプルファイル書き込み間隔　sec
//#define	HIGH_FLUSH_NUM	1
#define	HIGH_FLUSH_NUM	10

// 日付変化検出用
static struct tm	high_tm;
static struct tm	sec_tm;

//
/**** 時刻校正待ち
	パケット中の時刻が有効になるのを待つ

	Return:
		次の状態
*/
int ProcTimeFix(void)
{
	AdData	*d;
	static int	latest = -1;
	/*
		時刻校正終わったら、記録開始
	*/
	if (latest == ad_ring_latest_get()) return STS_TIME_FIX;
	latest = ad_ring_latest_get();
	if (latest >= 0) {
		// 最新データの時刻取得
		d = ad_ring_get(latest);
		// GPS Validチェック, tacc < 1000nsec
		if (((d->gps.valid & 0x07) == 0x07) && (d->gps.tacc < 1000)) {
			PDEBUG("ProcTimeFix: rec init.\n");
			return STS_REC_INIT;
		}
	}
	return STS_TIME_FIX;
}

//
/**** 記録初期化

	Return:
		次の状態
*/
int ProcRecInit(void)
{
	AdData	*d;
	
	if (ad_ring_latest_get() >= 0) {
		// 記録開始
		ad_ring_clear_sec();
		ad_ring_clear_high();

		// 最新データの時刻取得
		d = ad_ring_get(ad_ring_latest_get());
		// 日付変化検出用変数初期化
		high_tm = d->t;
		sec_tm = d->t;
	
		PDEBUG("ProcRecInit: rec start.\n");
		return STS_REC;
	}
	return STS_REC_INIT;
}

/**** 記録中
	定期的にカードに書き込み

	Return:
		次の状態
*/
int ProcRec(void)
{
	AdData	*d;
	FILE	*fp = NULL;
	char	buf[HIGH_WRITE_LEN_MAX+128];
	
//
/**** 1secデータ記録
*/
	/*
		パケットバッファにデータたまった?
	*/
	if (ad_ring_num_get_sec() >= SEC_FLUSH_NUM) {
		// データ取り出し
		d = ad_ring_get(ad_ring_read_get_sec());
		// ファイルオープン
		sec_file_open(&fp, d);

		// 書き込みループ
		while(ad_ring_num_get_sec() > 0) {
			// データ取り出し
			d = ad_ring_get(ad_ring_read_get_sec());
#if 0
PDEBUG("%04d/%02d/%02d %02d:%02d:%02d.%09ld,%6lums,%6luns,%02X",
	d->gps.year, d->gps.month, d->gps.day, d->gps.hour, d->gps.min, d->gps.sec, d->gps.nano,
	d->gps.tow, d->gps.tacc, d->gps.valid);
int ch;
for(ch = 0; ch < AD_CHNUM; ch++) {
	PDEBUG(",%+7ld", d->data1sec[ch]);
}
PDEBUG("\r\n");
#endif

			// 日にち変わった　ファイル切換する
#ifdef	DEBUG_FILE_MIN
			// デバッグ用　?分ごとファイル切り替え
			if ((d->t.tm_min % DEBUG_FILE_MIN_PERIOD) == 0 && (d->t.tm_sec == 0) && (d->t.tm_min != sec_tm.tm_min)) {
#else
			if (d->t.tm_year != sec_tm.tm_year || d->t.tm_mon != sec_tm.tm_mon || d->t.tm_mday != sec_tm.tm_mday) {
#endif
				// 日付変わったのでファイル切り替える
				// 前のファイル閉じる
				if (fp != NULL) sec_file_close(fp);
				// ファイルオープン
				if (sec_file_open(&fp, d)) {
					PDEBUG("REC: FG file change ERROR\n");
					syslog(LOG_INFO, "REC: FG file change ERROR\n");
				} else {
					PDEBUG("REC: FG file change OK\n");
					syslog(LOG_INFO, "REC: FG file change OK\n");
				}
			}
			// ファイルに書き込むデータ作成
			sec_make_rec_data(d, buf);
			// ファイルに１データ書き込み　Open/Closeなし
			if (sec_file_out(fp, buf, strlen(buf))) {
				/*	書き込みエラー */
				// 読み出し位置クリア
				ad_ring_clear_sec();
				// ファイル閉じる
				sec_file_close(fp);
				//
				PDEBUG("ProcRec: 1sec file write err\n");
				syslog(LOG_INFO, "REC: 1sec file write error\n");
				return STS_FILE_ERR;
			}
			// 読み込み位置進める
			ad_ring_read_plus_sec();
			// タイムスタンプ記録
			sec_tm = d->t;
		}
		// ファイル閉じる
		sec_file_close(fp);
		//
		PDEBUG("ProcRec: 1sec file write.\n");
	}
//
/**** 高速サンプルデータ記録
*/
	/*
		パケットバッファにデータたまった?
	*/
	if (ad_ring_num_get_high() >= HIGH_FLUSH_NUM) {
		// データ取り出し
		d = ad_ring_get(ad_ring_read_get_high());
		// ファイルオープン
		high_file_open(&fp, d);

		// 書き込みループ
		while(ad_ring_num_get_high() > 0) {
			// データ取り出し
			d = ad_ring_get(ad_ring_read_get_high());
			// 時が変わった　ファイル切換する
#ifdef	DEBUG_FILE_MIN
			// デバッグ用　?分ごとファイル切り替え
			if ((d->t.tm_min % DEBUG_FILE_MIN_PERIOD) == 0 && (d->t.tm_high == 0) && (d->t.tm_min != hightm.tm_min)) {
#else
			if (d->t.tm_year != high_tm.tm_year || d->t.tm_mon != high_tm.tm_mon || d->t.tm_mday != high_tm.tm_mday
			|| d->t.tm_hour != high_tm.tm_hour) {
#endif
				// 時が変わったのでファイル切り替える
				// 前のファイル閉じる
				if (fp != NULL) high_file_close(fp);
				// ファイルオープン
				if (high_file_open(&fp, d)) {
					PDEBUG("REC: FG file change ERROR\n");
					syslog(LOG_INFO, "REC: HIGH file change ERROR\n");
				} else {
					PDEBUG("REC: FG file change OK\n");
					syslog(LOG_INFO, "REC: HIGH file change OK\n");
				}
			}
			// ファイルに書き込むデータ作成
			high_make_rec_data(d, buf);
			// ファイルに１データ書き込み　Open/Closeなし
			if (high_file_out(fp, buf, HIGH_WRITE_LEN)) {
				/*	書き込みエラー */
				// 読み出し位置クリア
				ad_ring_clear_high();
				// ファイル閉じる
				high_file_close(fp);
				//
				PDEBUG("ProcRec: HIGH file write err\n");
				syslog(LOG_INFO, "REC: HIGH file write error\n");
				return STS_FILE_ERR;
			}
			// 読み込み位置進める
			ad_ring_read_plus_high();
			// タイムスタンプ記録
			high_tm = d->t;
		}
		// ファイル閉じる
		high_file_close(fp);
		//
		PDEBUG("ProcRec: HIGH file write.\n");
	}

	return STS_REC;
}

void* thread_rec(void* pParam)
{
	while(1) {
		usleep(10*1000);
		switch (sts_get()) {
			/*	時刻校正中 */
			case STS_TIME_FIX:
				sts_set(ProcTimeFix());
				break;
			/*	記録初期化 */
			case STS_REC_INIT:
				sts_set(ProcRecInit());
				break;
			/*	記録中 */
			case STS_REC:
				sts_set(ProcRec());
				break;
			/*	記録OFF中 */
			case STS_REC_OFF:
//				sts_set(ProcRecOff());
				break;
			/*	ファイルエラー発生中 */
			case STS_FILE_ERR:
//				sts_set(ProcErr());
				break;
			default:
				break;
		}
	} // メインループ終わり
}
