/*
	Ring Buffer用基本機能
	write位置
	read位置
*/
#include <stdlib.h>
#include <pthread.h>
#include <semaphore.h> 

#include "ring.h"

#define	READ_NUM_MAX	256
// ミューテックス
static pthread_mutex_t	mutex_ring = PTHREAD_MUTEX_INITIALIZER;

/*
	int	read_num
		読み込みポインタの個数
*/
RING_T* ring_create(int read_num)
{
	RING_T	*t;
	if (read_num <= 0) return NULL;
	if (read_num > READ_NUM_MAX) return NULL;
	
	t = malloc(sizeof(RING_T));
	if (t != NULL) {
		// readポインタ確保
		t->read = malloc(sizeof(int) * read_num);
		if (t->read == NULL) {
			free(t);
			return NULL;
		}
		t->read_num = read_num;
	}
	return t;
}
void ring_destroy(RING_T *t)
{
	free(t->read);
	free(t);
}
/*
	int num:	バッファの個数
*/
void ring_init(RING_T *t, int num)
{
	int	i;
	
pthread_mutex_lock(&mutex_ring);
	t->write = 0;
	for(i = 0; i < t->read_num; i++) {
		t->read[i] = 0;
	}
	t->latest = -1;
	t->num = num;
pthread_mutex_unlock(&mutex_ring);
}
void ring_clear(RING_T *t, int no)
{
	ring_read_set(t, no, ring_write_get(t));
}
/*
	読み出し位置
	int no
		readポインタ番号
*/
int ring_read_get(RING_T *t, int no)
{
	int	i;
pthread_mutex_lock(&mutex_ring);
	i = t->read[no];
pthread_mutex_unlock(&mutex_ring);
	return i;
}
void ring_read_set(RING_T *t, int no, int i)
{
pthread_mutex_lock(&mutex_ring);
	t->read[no] = i;
pthread_mutex_unlock(&mutex_ring);
}
void ring_read_plus(RING_T *t, int no)
{
pthread_mutex_lock(&mutex_ring);
	t->read[no]++;
	if (t->read[no] >= t->num) t->read[no] = 0;
pthread_mutex_unlock(&mutex_ring);
}

// 書き込み位置
int ring_write_get(RING_T *t)
{
	int	i;
pthread_mutex_lock(&mutex_ring);
	i = t->write;
pthread_mutex_unlock(&mutex_ring);
	return i;
}
void ring_write_plus(RING_T *t)
{
pthread_mutex_lock(&mutex_ring);
	t->write++;
	if (t->write >= t->num) t->write = 0;
pthread_mutex_unlock(&mutex_ring);
}
// 読み込んでいないデータ数
int ring_num_get(RING_T *t, int no)
{
	int	i;
	
pthread_mutex_lock(&mutex_ring);
	i = t->write - t->read[no];
	if (i < 0) i += t->num;
pthread_mutex_unlock(&mutex_ring);
	return i;
}
// 最新データ位置
int ring_latest_get(RING_T *t)
{
	int	i;
pthread_mutex_lock(&mutex_ring);
	i = t->latest;
pthread_mutex_unlock(&mutex_ring);
	return i;
}
void ring_latest_set(RING_T *t, int i)
{
pthread_mutex_lock(&mutex_ring);
	t->latest = i;
pthread_mutex_unlock(&mutex_ring);
}

/*
	パケットバッファフル？
	1=Full
	0=not Full
*/
int ring_is_full(RING_T *t, int no)
{
	if (ring_num_get(t, no) >= t->num - 1) return 1;
	return 0;
}
