/*
	本番でも出力するメッセージ
*/
#if !defined(__MES_PRINT_H__)
#define	__MES_PRINT_H__

#include <stdio.h>
#include <errno.h>

#define	MES_PRINT

#undef PMES
#undef PMESF
#undef PERR
#undef PERRF
#undef PMESF_NULL

#ifdef MES_PRINT
// ノーマル
#  define PMES(fmt, args...) fprintf(stdout, fmt, ## args)

// 関数名付き
#  define PMESF(fmt, args...) \
	fprintf(stdout, "%s() ", __FUNCTION__); \
	fprintf(stdout, fmt, ## args)

// エラー
#  define PERR(fmt, args...) \
	fprintf(stderr, fmt, ## args)
// エラー 関数名付き
#  define PERRF(fmt, args...) \
	fprintf(stderr, "%s() ", __FUNCTION__); \
	fprintf(stderr, fmt, ## args)
// NULLチェック
#define	PMESF_NULL(var) \
	if (var == NULL) { \
		fprintf(stderr, "%s() ", __FUNCTION__); \
		fprintf(stderr, "%s==NULL\n", #var); \
		fflush(stderr); \
	}
#else
#  define PMES(fmt, args...)
#  define PMESF(fmt, args...)
#  define PERR(fmt, args...)
#  define PERRF(fmt, args...)
#  define PMESF_NULL(var)
#endif

#endif
