#if	!defined(__I2CLCD_H__)
#define	__I2CLCD_H__

#define I2CLCD_ADDRESS 0x7c
// i2c LCDモジュール設定用
#define I2CLCD_CFG_ENABLE 0x20
#define I2CLCD_CFG_LED 0x08
#define I2CLCD_CFG_3V 0x04
#define I2CLCD_CFG_ADDR 0x02
#define I2CLCD_CFG_INIT 0x01

// commands
#define I2CLCD_CLEARDISPLAY 0x01
#define I2CLCD_RETURNHOME 0x02
#define I2CLCD_ENTRYMODESET 0x04
#define I2CLCD_DISPLAYCONTROL 0x08
#define I2CLCD_CURSORSHIFT 0x10
#define I2CLCD_FUNCTIONSET 0x20
#define I2CLCD_SETCGRAMADDR 0x40
#define I2CLCD_SETDDRAMADDR 0x80

// flags for display entry mode
#define I2CLCD_ENTRYRIGHT 0x00
#define I2CLCD_ENTRYLEFT 0x02
#define I2CLCD_ENTRYSHIFTINCREMENT 0x01
#define I2CLCD_ENTRYSHIFTDECREMENT 0x00

// flags for display on/off control
#define I2CLCD_DISPLAYON 0x04
#define I2CLCD_DISPLAYOFF 0x00
#define I2CLCD_CURSORON 0x02
#define I2CLCD_CURSOROFF 0x00
#define I2CLCD_BLINKON 0x01
#define I2CLCD_BLINKOFF 0x00

// flags for display/cursor shift
#define I2CLCD_DISPLAYMOVE 0x08
#define I2CLCD_CURSORMOVE 0x00
#define I2CLCD_MOVERIGHT 0x04
#define I2CLCD_MOVELEFT 0x00

// flags for function set
#define I2CLCD_8BITMODE 0x10
#define I2CLCD_4BITMODE 0x00
#define I2CLCD_2LINE 0x08
#define I2CLCD_1LINE 0x00
#define I2CLCD_5x10DOTS 0x04
#define I2CLCD_5x8DOTS 0x00

#define	LCD_YMAX	4
#define	LCD_XMAX	20

void lcd_init(void);
void lcd_pos(int x, int y);
void lcd_print(char *str);
void lcd_clear(void);
void lcd_home(void);

#endif
