#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/i2c-dev.h> /* for I2C_SLAVE */

#include "mes_print.h"
#include "lcd.h"

#define	DEV_LCD	"/dev/i2c-3"


static int	fh = -1;

static int lcd_open(void)
{
	fh = open(DEV_LCD, O_RDWR);
	return fh;
}
static void lcd_close(void)
{
	close(fh);
	fh = -1;
}
// 1byte out
static void lcd_out(unsigned char dat, char rs)
{
	unsigned char data[2];

	if (lcd_open() < 0) {
		PERRF("ERROR lcd_open()\n");
		return;
	}
	ioctl(fh, I2C_SLAVE, I2CLCD_ADDRESS >> 1);

	data[0] = rs ? 0x40 : 0x00;	// RS
	data[1] = dat;
	write(fh, data, 2);

	lcd_close();
}
/*
	複数バイトout
	RS=1
*/
static void lcd_out_mul(unsigned char *out, int len)
{
	unsigned char	data[256];

	if (lcd_open() < 0) {
		PERRF("ERROR lcd_open()\n");
		return;
	}
	ioctl(fh, I2C_SLAVE, I2CLCD_ADDRESS >> 1);

	data[0] = 0x40;	// RS = 1
	if (len >= sizeof(data)) len = sizeof(data)-1;
	memcpy(data+1, out, len);
	write(fh, data, len+1);

	lcd_close();
}
/*
	i2c LCDモジュールの設定
*/
static void i2clcd_init(void)
{
	unsigned char data[16];
	unsigned char	cfg;

	fh = -1;
	if (lcd_open() < 0) {
		PERRF("ERROR lcd_open()\n");
		return;
	}
	ioctl(fh, I2C_SLAVE, I2CLCD_ADDRESS >> 1);

	cfg = 0;
	data[0] = I2CLCD_CFG_ENABLE | (cfg & 0x1f);
	data[1] = 0;
	write(fh, data, 2);

	lcd_close();
}
/*
	LCD初期化
*/
void lcd_init(void)
{
	unsigned char	func, display, entry;
	
	i2clcd_init();
	usleep(10*1000);

	lcd_out(0x30, 0);
	usleep(5*1000);
	lcd_out(0x30, 0);
	usleep(2*1000);
	lcd_out(0x30, 0);

	func = I2CLCD_8BITMODE | I2CLCD_2LINE | I2CLCD_5x8DOTS;
//	shift = 
	display = I2CLCD_DISPLAYON | I2CLCD_CURSOROFF | I2CLCD_BLINKOFF;
	entry = I2CLCD_ENTRYLEFT;

	lcd_out(0x20 | (func & 0x1f), 0); // func 
//	lcd_out(0x10 | (shift & 0x0f), 0); // shift
	lcd_out(0x08 | (display & 0x07), 0); // display
	lcd_out(0x04 | (entry & 0x03), 0); // entry mode

	lcd_clear();
	lcd_home();
}
/*
	int x,y: 0始まり
*/
void lcd_pos(int x, int y)
{
	unsigned char	adr;
	unsigned char	ofs[] = {0, 0x40, 0x14, 0x54 };
	
	if (y >= LCD_YMAX) y = LCD_YMAX - 1;
	if (x >= LCD_XMAX) x = LCD_XMAX - 1;
	adr = ofs[y] + x;
	lcd_out(I2CLCD_SETDDRAMADDR | (adr & 0x7F), 0);
}

void lcd_print(char *str)
{
	lcd_out_mul((unsigned char*)str, strlen(str));
}
void lcd_clear(void)
{
	lcd_out(I2CLCD_CLEARDISPLAY, 0);
usleep(2*1000);
}
void lcd_home(void)
{
	lcd_out(I2CLCD_RETURNHOME, 0);
usleep(2*1000);
}


