/*
	本番では抑制するデバッグメッセージ
*/
#undef PDEBUG
#undef PDEBUGF
#undef PDEBUGF_ERR
#undef PDEBUGF_NULL

// リリース時はコメント
//#define	DEBUG_PRINT

#ifdef DEBUG_PRINT
#  ifdef __KERNEL__
#    define PDEBUG(fmt, args...) printk(KERN_DEBUG "scull: " fmt, ## args)
#  else
// ノーマル
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)

// 関数名付き
#    define PDEBUGF(fmt, args...) \
       fprintf(stderr, "%s() ", __FUNCTION__); \
       fprintf(stderr, fmt, ## args); \
       fflush(stderr)
// エラー
#    define PDEBUGF_ERR(fmt, args...) \
       fprintf(stderr, "%s() ", __FUNCTION__); \
       fprintf(stderr, fmt, ## args); \
		perror("errno string"); \
       fflush(stderr)
// NULLチェック
#define	PDEBUGF_NULL(var) \
		if (var == NULL) { \
			fprintf(stderr, "%s() ", __FUNCTION__); \
			fprintf(stderr, "%s==NULL\n", #var); \
			fflush(stderr); \
		}
#  endif
	

#else
#  define PDEBUG(fmt, args...)
#  define PDEBUGF(fmt, args...)
#  define PDEBUGF_ERR(fmt, args...)
#  define	PDEBUGF_NULL(var)
#endif

