#include <pthread.h>
#include <semaphore.h> 
#include <string.h>
#include <syslog.h>
#include <stdio.h>

#include "conf.h"
#include "debug_print.h"

// ミューテックス
static pthread_mutex_t	mutex_conf = PTHREAD_MUTEX_INITIALIZER;

//
/**** 記録周波数 ***************************************************
*/
// 50,25,10,5,2,1
static int	freq;

void conf_freq_set(int f)
{
pthread_mutex_lock(&mutex_conf);
	freq = f;
pthread_mutex_unlock(&mutex_conf);
}
int conf_freq_get(void)
{
	int	f;
pthread_mutex_lock(&mutex_conf);
	f = freq;
pthread_mutex_unlock(&mutex_conf);
	return f;
}
//
/**** Gain ***************************************************
*/
/*
	0=1/8, 1=1/4, 2=1/2, 3=1, 4=2, 5=4
	6=8, 7=16, 8=32, 9=64, 10=128
*/
static int	gain;

void conf_gain_set(int f)
{
pthread_mutex_lock(&mutex_conf);
	gain = f;
pthread_mutex_unlock(&mutex_conf);
}
int conf_gain_get(void)
{
	int	f;
pthread_mutex_lock(&mutex_conf);
	f = gain;
pthread_mutex_unlock(&mutex_conf);
	return f;
}

/**** Linux時刻セット ***************************************************
*/
// 1=ON
static int linux_time_set;
void conf_linux_time_set_set(int val)
{
	linux_time_set = val;
}
int conf_linux_time_set_get(void)
{
	return linux_time_set;
}

//
/**** 設定ファイル *******************************************
*/
/*
	文字列の前から空白を取り除く
*/
static void trims_space(char *name)
{
	char	c;
	char	*name0;
	int	len;
	
	name0 = name;
	len = strlen(name);
	
	// 最初の非空白文字までポインタ移動
	while (*name) {
		c = *name;
		if (c != ' ') break;
		name++;
		len--;
	}
	if (len < 0) return;
	// 移動
	if (name0 != name) memmove(name0, name, len);
	// 末尾に０入れる
	name0[len] = 0;
}
/*
	文字列の後ろから空白を取り除く
*/
static void trime_space(char *name)
{
	char	c;
	int	len, i;

	// 文字列末尾
	len = strlen(name);
	name += (len - 1);
	// 最初の非空白文字までポインタ移動
	for(i = len - 1; i >= 0; i--) {
		c = *name;
		if (c != ' ') break;
		name--;
	}
	// 末尾に０入れる
	*(name + 1) = 0;
}
/*
	文字列の前後から空白を取り除く
*/
static void trim_space(char *name)
{
	if (name == NULL) return;
	trims_space(name);
	trime_space(name);
}
/*
	文字列の末尾からCR LFを除く
*/
static void trim_crlf(char *name)
{
	int	i;
	int	len;
	char	*src, *dst;
	
	if (name == NULL) return;
	len = strlen(name);
	src = name;
	dst = name;
	for(i = 0; i < len; i++) {
		if (*src != 0x0d && *src != 0x0a) {
			*dst = *src;
			dst++;
		}
		src++;
	}
	*dst = 0;
}

/*
	読み込み

return
	-1=ERR
	0=OK
*/
int conf_read(void)
{
	FILE	*fp;
	char	buf[256];
//	char	buf2[256];
	int	f;
	int	val;
	
	fp = fopen(CONF_FILE, "rt");
	if (fp == NULL) {
		syslog(LOG_ERR, "conf_read(): conf file not found. %s", CONF_FILE);
		return -1;
	}

	syslog(LOG_INFO, "conf_read():");
	while(fgets(buf, sizeof(buf), fp)) {
		// CR LF除く
		trim_crlf(buf);
		trim_space(buf);
		PDEBUG(buf);
		PDEBUG("\n");
		// 記録周波数
		if (sscanf(buf, "freq = %d", &f) == 1) {
			conf_freq_set(f);
			syslog(LOG_INFO, "freq=%d", conf_freq_get());
		} 
		// Gain
		if (sscanf(buf, "gain = %d", &f) == 1) {
			conf_gain_set(f);
			syslog(LOG_INFO, "gain=%d", conf_gain_get());
		} 
		// Linux時刻セット
		if (sscanf(buf, "linux_time_set = %d", &val) == 1) {
			conf_linux_time_set_set(val);
			syslog(LOG_INFO, "linux_time_set=%d", conf_linux_time_set_get());
		} 
	}
	fclose(fp);
	return 0;
}


