/*
	1secファイル
	高速サンプルファイル

#define	DEBUG_FILE_MIN
	定義するとファイルが1日単位ではなく指定された分単位になる
	ただし、ファイルのサイズは1日と同じサイズのまま
#deifne	DEBUG_FILE_MIN_PERIOD
	ファイルの単位
	単位　分

*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>
#include <unistd.h>

#include "ad_ring.h"
#include "ad_file.h"
#include "debug_print.h"
#include "conf.h"

// mkdir_p()で使用する
#define	MKDIR_MODE	"755"

/**** util
*/
/*
	指定さえれたディレクトリを作成
	親がないときは親まで作る
	char *mode
		755とか
	return
		0=OK
		-1=ERROR
*/
static int mkdir_p(const char *path, char *mode)
{
	struct stat	st;
	char	cmd[128];

	// コピー先ディレクトリ存在しなければ作成する
	if (stat(path, &st) == -1) {
		PDEBUG("mkdir_p(): make dir %s\n", path);

		sprintf(cmd, "mkdir -p -m %s %s > /dev/null 2> /dev/null &", mode, path);
		switch(system(cmd)) {
			case 127:
				// shell exec error
				PDEBUG("mkdir_p(): shell exec error\n");
				syslog(LOG_ERR, "mkdir_p(): system() shell exec error");
				return -1;
			case -1:
				// error
				PDEBUG("mkdir_p(): error\n");
				syslog(LOG_ERR, "mkdir_p(): system() error");
				return -1;
			default:
				// 作成されるまで待つ
				sleep(3);
				return 0;
		}
	}
	return 0;
}


/**** 1秒ファイル関係 ************************************************************
*/
/*
	１秒データファイル　オープン

	Return:
		1 = Error
		0 = OK
 */
int sec_file_open(FILE **fp, AdData *D)
{
	char	szDir[64];
	struct stat	st;
	char	fname[64];
	char	path[128];
	
	// サブディレクトリ作成
	sprintf(szDir, "%s/%04d/%02d", DIR_DATA, D->t.tm_year+1900, D->t.tm_mon+1);
	// ディレクトリ存在しなければ作成する
	if (stat(szDir, &st) == -1) mkdir_p(szDir, MKDIR_MODE);

	// ファイル名作成
#ifdef	DEBUG_FILE_MIN
	sprintf(fname, "%04d%02d%02d_%02d%02d.sec",
		D->t.tm_year+1900, D->t.tm_mon+1, D->t.tm_mday, D->t.tm_hour, D->t.tm_min / DEBUG_FILE_MIN_PERIOD * DEBUG_FILE_MIN_PERIOD);
#else
	sprintf(fname, "%04d%02d%02d.sec", D->t.tm_year+1900, D->t.tm_mon+1, D->t.tm_mday);
#endif
	// フルパス作成
	strcpy(path, szDir);
	strcat(path, "/");
	strcat(path, fname);
	PDEBUGF("path=%s\n", path);

	*fp = fopen(path, "a");
	if (*fp == NULL) {
		syslog(LOG_ERR, "%s(): fopen() ERROR. %s", __FUNCTION__, strerror(errno));
		return 1;
	}
	return 0;
}
/*
	Return:
		1 = Error
		0 = OK
 */
int sec_file_out(FILE *fp, char *out, int len)
{
	int	ret;

	if (fp == NULL) return 1;
	if ((ret = fwrite(out, 1, len, fp)) < len) {
		syslog(LOG_ERR, "%s(): fwrite() return %d < %d. %s", __FUNCTION__, ret, len, strerror(errno));
		return 1;
	}
	return 0;
}
/*
	１秒データファイル　クローズ

	Return:
		1 = Error
		0 = OK
 */
int sec_file_close(FILE *fp)
{
	if (fp == NULL) return 1;
	fclose(fp);
	return 0;
}

/*
	1secファイル記録用データ作る
*/
int sec_make_rec_data(AdData *ad, char *buf)
{
	char	buf2[32];
	int	ch;
	
	sprintf(buf, "%04d/%02d/%02d %02d:%02d:%02d,%3lu,%02X",
		ad->gps.year, ad->gps.month, ad->gps.day, ad->gps.hour, ad->gps.min, ad->gps.sec,
		ad->gps.tacc, ad->gps.valid);
	for(ch = 0; ch < AD_CHNUM; ch++) {
		sprintf(buf2, ",%+7ld", ad->data1sec[ch]);
		strcat(buf, buf2);
	}
	strcat(buf, "\n");
	return 0;
}
/**** 高速サンプルファイル関係 ************************************************************
*/
/*
	Return:
		1 = Error
		0 = OK
 */
int high_file_open(FILE **fp, AdData *D)
{
	char	szDir[64];
	struct stat	st;
	char	fname[64];
	char	path[128];
	
	// サブディレクトリ作成
	sprintf(szDir, "%s/%04d/%02d", DIR_DATA, D->t.tm_year+1900, D->t.tm_mon+1);
	// ディレクトリ存在しなければ作成する
	if (stat(szDir, &st) == -1) mkdir_p(szDir, MKDIR_MODE);

	// ファイル名作成
#ifdef	DEBUG_FILE_MIN
	sprintf(fname, "%04d%02d%02d_%02d%02d.sec",
		D->t.tm_year+1900, D->t.tm_mon+1, D->t.tm_mday, D->t.tm_hour, D->t.tm_min / DEBUG_FILE_MIN_PERIOD * DEBUG_FILE_MIN_PERIOD);
#else
	sprintf(fname, "%04d%02d%02d%02d.high", D->t.tm_year+1900, D->t.tm_mon+1, D->t.tm_mday, D->t.tm_hour);
#endif
	// フルパス作成
	strcpy(path, szDir);
	strcat(path, "/");
	strcat(path, fname);
	PDEBUGF("path=%s\n", path);

	*fp = fopen(path, "a");
	if (*fp == NULL) {
		syslog(LOG_ERR, "%s(): fopen() ERROR. %s", __FUNCTION__, strerror(errno));
		return 1;
	}
	return 0;
}
/*
	Return:
		1 = Error
		0 = OK
 */
int high_file_out(FILE *fp, char *out, int len)
{
	int	ret;

	if (fp == NULL) return 1;
	if ((ret = fwrite(out, 1, len, fp)) < len) {
		syslog(LOG_ERR, "%s(): fwrite() return %d < %d. %s", __FUNCTION__, ret, len, strerror(errno));
		return 1;
	}
	return 0;
}
/*
	Return:
		1 = Error
		0 = OK
 */
int high_file_close(FILE *fp)
{
	if (fp == NULL) return 1;
	fclose(fp);
	return 0;
}

/*
	高速サンプル記録データ
	記録用データ作る
*/
int high_make_rec_data(AdData *ad, char *ptr)
{
//	char	*src;
	int	ch, i;
	
	*ptr++ = ad->gps.year & 0xFF;
	*ptr++ = (ad->gps.year >> 8) & 0xFF;
	*ptr++ = ad->gps.month;
	*ptr++ = ad->gps.day;
	*ptr++ = ad->gps.hour;
	*ptr++ = ad->gps.min;
	*ptr++ = ad->gps.sec;
	memcpy(ptr, (char*)(&(ad->gps.tacc)), 4);
	ptr += 4;
	*ptr++ = ad->gps.valid;
	*ptr++ = ad->freq & 0xFF;
	*ptr++ = (ad->freq >> 8) & 0xFF;
	
	// 
//	src = (char*)ad->avg;
	for(ch = 0; ch < AD_CHNUM; ch++) {
		for(i = 0; i < ad->freq; i++) {
			memcpy(ptr, &(ad->avg[ch][i]), AD_BYTES);
			ptr += AD_BYTES;
//			for(j = 0; j < AD_BYTES; j++) {
//				*ptr++ = *src++;
//			}
//			src++;
		}
	}
	return 0;
}




