#ifndef __MYSPI_H__
#include <p24FJ64GA004.h>

#define __MYSPI_H__
void spi1_rx_fifo_clear(void);
void spi2_rx_fifo_clear(void);
int spi1_init(void);
int spi2_init(void);

#define spi1_tx_fifo_is_full()  (SPI1STATbits.SPITBF == 1) // true=full(Transmit not yet started, SPIxTXB is full)
#define spi1_rx_fifo_is_full()  (SPI1STATbits.SPIRBF == 1) // true=full(Receive complete)
#define spi1_rx_fifo_is_empty() (SPI1STATbits.SRXMPT == 1)    // true=empty, SRXMPT: Receive FIFO Empty bit (valid in Enhanced Buffer mode)
#define spi1_rx_overrun_clear() SPI1STATbits.SPIROV = 0;

#define spi1_putc(c)    SPI1BUF = (c & 0xFF)
#define spi1_getc()     (SPI1BUF & 0xFF)

#define spi1_set_int_level(i)  IPC2bits.SPI1IP = (i)
#define spi1_int_enable()   IEC0bits.SPI1IE = 1
#define spi1_int_disable()  IEC0bits.SPI1IE = 0
#define spi1_intf_clear()   IFS0bits.SPI1IF = 0

#define SPI2_SRXMPT SPI2STATbits.SRXMPT
#define SPI2_TBF    SPI2STATbits.SPITBF
#define SPI2_RBF    SPI2STATbits.SPITBF
#define spi2_tx_fifo_is_full()  (SPI2STATbits.SPITBF == 1) // true=full
#define spi2_rx_fifo_is_full()  (SPI2STATbits.SPIRBF == 1) // true=full
#define spi2_rx_fifo_is_empty() (SPI2STATbits.SRXMPT == 1)    // true=empty
#define spi2_rx_overrun_clear() SPI2STATbits.SPIROV = 0;

#define spi2_putc(c)    SPI2BUF = (c & 0xFF)
#define spi2_getc()     (SPI2BUF & 0xFF)

#define spi2_set_int_level(i)  IPC8bits.SPI2IP = (i)
#define spi2_int_enable()   IEC2bits.SPI2IE = 1
#define spi2_int_disable()  IEC2bits.SPI2IE = 0
#define spi2_intf_clear()   IFS2bits.SPI2IF = 0

#endif
