/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.swing.progress;

import javax.swing.ProgressMonitor;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.subr.SenaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.GUIElement;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/07/24
 */
public class MakeProgressMonitor extends SenaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.SenaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a,
			Datum c5a, Datum c6a, Environment env, LispMessage mesg) {
		ProgressMonitor mon;
		int millis = SubrUtils.getSmallInt(c1a, mesg);
		String mes = LispUtils.print(c3a);
		String not = LispUtils.print(c4a);
		int max = SubrUtils.getSmallInt(c5a, mesg);
		int min = SubrUtils.getSmallInt(c6a, mesg);

		if(min > max) {
			throw mesg.getError("err.range.invalid");
		} else if(millis < 0) {
			throw mesg.getError("err.require.int.nonnegative", c1a);
		} else if(c2a.isTrue() && !(c2a instanceof GUIElement)) {
			throw mesg.getError("err.swing.require.component", c2a);
		} else if(!c2a.isTrue()) {
			mon = new ProgressMonitor(null, mes, not, min, max);
		} else {
			mon = new ProgressMonitor(
					((GUIElement)c2a).getAWTComponent(),
					mes, not, min, max);
		}
		mon.setMillisToPopup(millis);
		mon.setProgress(min);
		return new LispProgressMonitor(mon);
	}

}
