/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.security.keypair;

import java.security.Key;
import java.security.PrivateKey;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.JavaObjective;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/04/12
 */
public class LispPrivateKey extends Datum2
implements ILispKey, JavaObjective, java.io.Serializable {

	//
	PrivateKey key;

	/**
	 * 
	 * @param key
	 */
	public LispPrivateKey(PrivateKey key) {
		this.key = key;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.security.keypair.ILispKey#getKey()
	 */
	@Override
	public Key getKey() {
		return key;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.JavaObjective#toObject()
	 */
	@Override
	public PrivateKey toObject() {
		return key;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum2#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<private-key>");
	}

}
